﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase creado para metodos de pago con tarjeta de debito o credito
    /// </summary>
    public class AdaptadorAddTenderDebitRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:AddTender";
        public string NombreElementoXMLDatos { get; set; } = "./AddTenderRequest"; 

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(AddTenderRequest));
            AddTenderRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);

            dto = (AddTenderRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");

            return dto;
        }

        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorAddTenderDebitRequest)this.MemberwiseClone();
        }

    }
}
