﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador "Obtener Totales"
    /// </summary>
    public class AdaptadorGetTotalsRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:GetTotals";
        public string NombreElementoXMLDatos { get; set; } = "./GetTotalsRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(GetTotalsRequest));
            GetTotalsRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);

            dto = (GetTotalsRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");

            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");

            return dto;
        }

        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorGetTotalsRequest)this.MemberwiseClone();
        }
     }
}
