﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador Inicializar Chec
    /// </summary>
    public class AdaptadorInitializeRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:Initialize";
        public string NombreElementoXMLDatos { get; set; } = "./InitializeRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            var dto = new InitializeRequestDTO(idSesion, tipoMensaje);
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.OperatorID = Util.LeeStringEnNodo(nodo, "./OperatorID");
            dto.TerminalNumber = Util.LeeIntEnNodo(nodo, "./TerminalNumber");
            dto.Recovery = Util.LeeBoolEnNodo(nodo, "./Recovery");
            return dto;
        }


        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorInitializeRequest)this.MemberwiseClone();
        }
    }
}
