﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// En este adaptador, manejamos el proceso para imprimir el Ticket en la impresora
    /// </summary>
    public class AdaptadorPrintCurrentReceipts : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:PrintCurrentReceipts";
        public string NombreElementoXMLDatos { get; set; } = "./PrintCurrentReceiptsRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(PrintCurrentReceiptsRequest));

            PrintCurrentReceiptsRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);
            dto = (PrintCurrentReceiptsRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;

            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");
            return dto;
        }

        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorPrintCurrentReceipts)this.MemberwiseClone();
        }
    }
}
