﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador Query Status
    /// </summary>

    public class AdaptadorQueryStatusRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:QueryStatus";
        public string NombreElementoXMLDatos { get; set; } = "./QueryStatusRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            var dto = new QueryStatusRequestDTO(idSesion, tipoMensaje);

            return dto;
        }


        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorQueryStatusRequest)this.MemberwiseClone();
        }
    }
}
