﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Entrada ReportStatusEventsRequest
    /// </summary>
    public class AdaptadorReportStatusEventsRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:ReportStatusEvents";
        public string NombreElementoXMLDatos { get; set; } = "./ReportStatusEventsRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            var dto = new ReportStatusEventsRequestDTO(idSesion, tipoMensaje);
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");
            return dto;
        }


        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorReportStatusEventsRequest)this.MemberwiseClone();
        }
    }
}
