﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador de cancelar transacción
    /// </summary>
    public class AdaptadoresVoidTransactionRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:VoidTransaction";
        public string NombreElementoXMLDatos { get; set; } = "./VoidTransactionRequest";
        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(VoidTransactionDTO));
            VoidTransactionDTO dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);
            dto = (VoidTransactionDTO)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");
            return dto;
        }

        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadoresVoidTransactionRequest)this.MemberwiseClone();
        }

    }
}
