﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Comando para procesar situaciones de error.
    /// </summary>
    public class ErrorCmd : IComando
    {
        /// <summary>
        /// Referencia del mensaje.
        /// </summary>
        public string Referencia { get; set; } = "error";
        /// <summary>
        /// Campo ErrorDTO
        /// </summary>
        public ErrorDTO? Error { get; private set; }

        /// <summary>
        /// Constructor desde un DTO con mensaje de texto.
        /// </summary>
        public Respuestas Ejecutar()
        {
            if (Error == null)
                Error = new ErrorDTO(1, TipoMensaje.Event, "Mensaje de error no inicializado.");
            return (new Respuestas { new RespuestaGenerica(Error.Texto) });
        }

        /// <summary>
        /// Retorna copia del comando.
        /// </summary>
        public IComando CreaCopia()
        {
            return (ErrorCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase errorDTO)
        {
            Error = (ErrorDTO)errorDTO;
        }
    }

}
