﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EvaPOS_API_FRAME.Comandos;
using System.Xml.Linq;
using System.Globalization;
using System.IO;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Comando que procesa el estado de pagar venta
    /// </summary>
    public class GetTotalsRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:GetTotals";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public GetTotalsRequest Request { get; private set; }

        /// <summary>
        /// Procesa y responde GetTotalsRequest.
        /// </summary>
        
        public Respuestas Ejecutar()
        {

            Log.Debug("Cmd GetTotalsRequestDTO ejecutado. GetTotalsRequest : {GetTotalsRequest}", Request.RequestID);
            
            GetTotalsResponse getTotalsResponse = null;
            POSReceiptEventResponse pOSReceiptEvent = null;
            TotalsEventResponse totalEvent = null;
            int RequestId = Request.RequestID;
            AddItemRequestCmd addItemRequestCmd = new AddItemRequestCmd();


            pOSReceiptEvent = new POSReceiptEventResponse(1, TipoMensaje.Event, RequestId, RequestId, "3200", "3200");
            totalEvent = new TotalsEventResponse(1, TipoMensaje.Event, RequestId, "3200", "3200", "3200", "3200", "0.00", "0.00", "0.00", "0.00", "0.00", 1, 0, "0.00", "0.00");
            getTotalsResponse = new GetTotalsResponse(1, TipoMensaje.Resp, RequestId, "3200", "3200", "3200", "3200", "0.00", "0.00", "0.00", "0.00", "0.00", 1, 0, "0.00", "0.00");
            

            return (new Respuestas { pOSReceiptEvent,totalEvent, getTotalsResponse });

        }

        public IComando CreaCopia()
        {
            return (GetTotalsRequestCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase getTotalsRequestDTO)
        {
            Request = (GetTotalsRequest)getTotalsRequestDTO;
        }

    }
}
