﻿using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.Printer;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Configuration;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Procesa solicitudes de InitializeRequest.
    /// </summary>
    public class InitializeRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:Initialize";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public InitializeRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde InitializeRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            int terminalNumber = Request.TerminalNumber;
            Log.Debug("Cmd InitializeRequestCmd ejecutado. Request id: {id}, terminal: {terminal}, recovery: {recovery}", Request.OperatorID, Request.TerminalNumber, Request.Recovery);
           
            var posbcStatus1 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "CONNECTING_TO_POS", "Connecting to POS system");
            var posbcStatus2 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "CONNECTED_TO_POS", "Connected to POS system");
            var posbcStatus3 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "POS_RESOURCES_INITIALIZED", "POS Resources Initialized");
            var inicializacionOk = new InitializeResponse(1, TipoMensaje.Resp, terminalNumber);
            return (new Respuestas { posbcStatus1, posbcStatus2, posbcStatus3,inicializacionOk });
        }

        public IComando CreaCopia()
        {
            return (InitializeRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase initializeRequestDTO)
        {
            Request = (InitializeRequestDTO)initializeRequestDTO;
        }

    }
}
