﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.Printer;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Comando que procesa las solicitudes de la impresora    
    ///</summary>
    public class PrintCurrentReceiptsRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:PrintCurrentReceipts";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public PrintCurrentReceiptsRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde eventos de la impresora dependiendo al id
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd PrintCurrentReceiptsRequesDTO ejecutado. PrintCurrentReceiptsReques : {PrintCurrentReceiptsReques}", Request.RequestID);
            int requestId = Request.RequestID;
            var posbcEventPrinter = new POSBCStatusEventPrinter(1, TipoMensaje.Event, "INFO", "PRINTING", "Printing Job", 1, 1);
            var printCurrentReceipts = new PrintCurrentReceiptsResponse(1,TipoMensaje.Resp, requestId);

            return (new Respuestas { posbcEventPrinter, printCurrentReceipts });
        }


        public IComando CreaCopia()
        {
            return (PrintCurrentReceiptsRequestCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase printCurrentReceiptsRequestDTO)
        {
            Request = (PrintCurrentReceiptsRequest)printCurrentReceiptsRequestDTO;
        }
    }
}
