﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Procesa solicitudes de QueryStatusRequest.
    /// </summary>
    public class QueryStatusRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:QueryStatus";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public QueryStatusRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde QueryStatusRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            
            //Mirar las tildes que hay problema con el chec
            var date = DateTime.Now.ToString("dd MM yyyy");
            CultureInfo culture = new CultureInfo("en-US");
            culture.DateTimeFormat.AMDesignator = "AM";
            culture.DateTimeFormat.PMDesignator = "PM";
            var time = DateTime.Now.ToString("hh:mm tt", culture);
            Log.Debug("Cmd QueryStatusRequesttDTO ejecutado. QueryStatusRequest : {QueryStatusRequest}", Request.QueryStatusRequest);
            var queryStatusResponse = new QueryStatusResponse(1, TipoMensaje.Resp, 2, "NOT_IN_TRANSACTION", 4, 2, 2067, "Toshiba Store Integrator Application Extension Facility version: 4.2.2067 Built: Jun 08, 2021 06:49 PM (SI.base.wyvern )", "28 de abril de 2023 05:31:35 PM COT",2, false);
            return (new Respuestas { queryStatusResponse });
        }
      
        public IComando CreaCopia()
        {
            return (QueryStatusRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase queryStatusRequestDTO)
        {
            Request = (QueryStatusRequestDTO)queryStatusRequestDTO;
        }
    }
}
