﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static EvaPOS_API_FRAME.DTO.RemoveReceiptLinesDTO;

namespace EvaPOS_API_FRAME.Comandos
{
    public class RemoveReceiptLinesCmd : IComando
    {
        /// <summary>
        /// Comando que procesa la solicitud de CHEC "Saltar a la bolsa"
        /// </summary>
        public string Referencia { get; set; } = "scsns:RemoveReceiptLines";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public RemoveReceiptLinesRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde ReportStatusEventsRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddReceiptLinesRequestCmd ejecutado. AddReceiptLinesRequest : {AddReceiptLinesRequest}", Request.RequestID);
            int requestId = Request.RequestID;
            var removeReceiptLinesResponse = new RemoveReceiptLinesResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { removeReceiptLinesResponse });

        }
       

        public IComando CreaCopia()
        {
            return (RemoveReceiptLinesCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase removeReceiptLinesRequest)
        {
            Request = (RemoveReceiptLinesRequest)removeReceiptLinesRequest;
        }


    }
}
