﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.Reprint;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa el comando cuando se va a reimprimir una transacción
    /// </summary>
    public class ReprintReceiptsCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:ReprintReceipts";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public ReprintReceiptsRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde del evento reimprimir.
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd ReprintReceiptsRequestDTO ejecutado. ReprintReceiptsRequest : {ReprintReceiptsRequest}", Request.RequestID);

            ReprintReceiptsResponse reprintReceipts = null;
            int requestId = Request.RequestID;
            reprintReceipts = new ReprintReceiptsResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { reprintReceipts });

        }
 
        public IComando CreaCopia()
        {
            return (ReprintReceiptsCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase reprintReceiptsDTO)
        {
            Request = (ReprintReceiptsRequestDTO)reprintReceiptsDTO;
        }

    }
}
