﻿using EvaPOS_API_FRAME.Comandos;
using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.Printer;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace gatewayGK.ComandosGk
{
    ///<summary>
    /// Procesa solicitudes de ReportStatusEventsRequest.
    /// </summary>
    public class ReportStatusEventsRequestCmdGk : IComando
    {
        public string Referencia { get; set; } = "scsns:ReportStatusEvents";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public ReportStatusEventsRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde ReportStatusEventsRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd ReportStatusEventsRequestDTO ejecutado. ReportStatusEventsRequest : {ReportStatusEventsRequest}", Request.RequestID);
            POSBCStatusEventPrinterSingle posbcStatusPrinter = null;
            
            int requestId = Request.RequestID;

            var reportStatusEventsResponse = new ReportStatusEventsResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { reportStatusEventsResponse });
        }

        public IComando CreaCopia()
        {
            return (ReportStatusEventsRequestCmdGk)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase reportStatusEventsRequestDTO)
        {
            Request = (ReportStatusEventsRequestDTO)reportStatusEventsRequestDTO;
        }
    }
}
