﻿using EvaPosSrvDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.DTO
{
    ///<summary>
    /// DTO que obtiene los valores del XML "Agregar Artículo"
    /// </summary>

    [XmlRoot(ElementName = "BarCode")]
    public class BarCode
    {

        [XmlElement(ElementName = "ScanDataLabel")]
        public long ScanDataLabel { get; set; } = 0;

        [XmlElement(ElementName = "ScanDataType")]
        public string ScanDataType { get; set; } = null;
    }

    [XmlRoot(ElementName = "ItemIdentifier")]
    public class ItemIdentifier
    {
        [XmlElement(ElementName = "KeyedItemID")]
        public long KeyedItemID { get; set; } = 0;
        [XmlElement(ElementName = "ItemIDIncludesCheckDigit")]
        public bool ItemIDIncludesCheckDigit { get; set; } = false;
        [XmlElement(ElementName = "BarCode")]
        public BarCode BarCode { get; set; }

        [XmlElement(ElementName = "Quantity")]
        public int Quantity { get; set; }
        [XmlElement(ElementName = "VoidFlag")]
        public bool VoidFlag { get; set; } = false;
        [XmlElement(ElementName = "ScaleWeight")]
        public double ScaleWeight { get; set; } = 0;
    }

    [XmlRoot(ElementName = "AddItemRequest")]
    public class AddItemRequestDTO : DTOBase
    {
        public AddItemRequestDTO(int idSesion, TipoMensaje tipo) : base(idSesion, tipo)
        {
        }
        public AddItemRequestDTO() 
        {
        }

        [XmlElement(ElementName = "ParameterExtension")]
        public object ParameterExtension { get; set; }

        [XmlElement(ElementName = "RequestID")]
        public int RequestID { get; set; }

        [XmlElement(ElementName = "ItemIdentifier")]
        public ItemIdentifier ItemIdentifier { get; set; }
    }
}
