﻿using EvaPosSrvDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.DTO
{
    ///<summary>
    /// DTO que obtiene los valores del XML "Pagar con tarjeta débito o crédito"
    /// </summary>

    [XmlRoot(ElementName = "DebitIdentifier")]
    public class DebitIdentifier
    {

        [XmlElement(ElementName = "Amount")]
        public double Amount { get; set; }

        [XmlElement(ElementName = "IsVoid")]
        public bool IsVoid { get; set; }

        [XmlElement(ElementName = "CashBackAmount")]
        public int CashBackAmount { get; set; }
    }
    [XmlRoot(ElementName = "CreditIdentifier")]
    public class CreditIdentifier
    {
        [XmlElement(ElementName = "Amount")]
        public double Amount { get; set; }
        [XmlElement(ElementName = "Description")]
        public string Description { get; set; }
        [XmlElement(ElementName = "IsVoid")]
        public bool IsVoid { get; set; }
    }

    [XmlRoot(ElementName = "AddTenderRequest")]
    public class AddTenderRequest : DTOBase
    {
        public AddTenderRequest(int idSesion, TipoMensaje tipo) : base(idSesion, tipo)
        {

        }
        public AddTenderRequest()
        { 
        
        }

        [XmlElement(ElementName = "ParameterExtension")]
        public object ParameterExtension { get; set; }

        [XmlElement(ElementName = "OperatorID")]
        public object OperatorID { get; set; }

        [XmlElement(ElementName = "EnableCallback")]
        public bool EnableCallback { get; set; }

        [XmlElement(ElementName = "RequestID")]
        public int RequestID { get; set; }

        [XmlElement(ElementName = "DebitIdentifier")]
        public DebitIdentifier DebitIdentifier { get; set; }
        [XmlElement(ElementName = "CreditIdentifier")]
        public CreditIdentifier CreditIdentifier { get; set; }

    }
}
