/// <summary>
///  Clase que representa los parámetros de configuración de la aplicación
///  registrados en el archivo appsettings.json asociados a Gk Smart POS.
/// </summary>
public sealed class ConfigGk
{
    public required string IpGkSmartPOS { get; set; } = "127.0.0.1";
    public required int PortGkSmartPOS { get; set; } = 8443;
    public required string TenantId { get; set; } = "";
    public required string RetailStoreId { get; set; } = "";
    public required string WorkstationId { get; set; } = "";
    public required string WorkstationAddress { get; set; } = "";
    public required string WorkstationTypeCode { get; set; } = "";
    public required string LoginName { get; set; } = "";
    public required string Password { get; set; } = "";
    public required string BusinessUnitGroupID { get; set; } = "";
    public required string TillID { get; set; } = "";

    public override string ToString()
    {
        return base.ToString() + " - "
           + $"IpGkSmartPOS: '{IpGkSmartPOS}', "
           + $"PortGkSmartPOS: '{PortGkSmartPOS}', "
           + $"TenantId: '{TenantId}', "
           + $"RetailStoreId: '{RetailStoreId}', "
           + $"WorkstationId: '{WorkstationId}', "
           + $"WorkstationAddress: '{WorkstationAddress}', "
           + $"WorkstationTypeCode: '{WorkstationTypeCode}', "
           + $"LoginName: '{LoginName}', "
           + $"Password: '{Password}', "
           + $"BusinessUnitGroupID: '{BusinessUnitGroupID}', "
           + $"TillID: '{TillID}'";
    }
}