/// <summary>
/// Esta clase reune la definición de constantes globales
/// requeridas por el programa. Particularmente, valores
/// predefinidos de configuración.
/// </summary> 
public static class Const
{
    /// <summary>
    /// Configuración. Indica tipo de pos de pruebas, para instanciar 
    /// comandos de prueba internos (dummy).
    /// </summary>
    public const string PosPruebas = "pruebas";
    /// <summary>
    /// Configuración. Indica tipo de pos GK, para instanciar 
    /// comandos para acceder Smart POS de GK.
    /// </summary>
    public const string PosGK = "gk";
    /// <summary>
    /// Configuración. Indica tipo de pos GK pruebas, para instanciar 
    /// comandos de prueba Smart POS de GK simulada.
    /// </summary>
    public const string PosGKPruebas = "gk_test";
    /// <summary>
    /// Configuración. Indica tipo de pos EvaPOS, para instanciar 
    /// comandos para acceder EvaPOS.
    /// </summary>
    public const string PosEvaPOS = "evapos";

}