
using GatewaySCO;
/// <summary>
/// Factory que retorna un directorio de comandos instanciado
/// con los comandos apropiados según tipo de POS.
/// </summary>
public class DirectorioCmdsFactory
    {
        public static CreaDirectorioCmds CreaDirectorio(string tipoPOS)
        {
        return tipoPOS switch
        {
            "ECO" => DispensaDirectorioCmdsPruebas.Dispensa(),
            //"ECO_POSBC" => throw new NotImplementedException(),
            "ECO_POSBC" => DispensaDirectorioCmdsGKPruebas.Dispensa(),
            "POSBC" => throw new NotImplementedException(),
            "evapos" => DispensaDirectorioCmdsEvaPOS.Dispensa(),
            "gk" => DispensaDirectorioCmdsGK.Dispensa(),
            "gk_test" => DispensaDirectorioCmdsGKPruebas.Dispensa(),
            _ => throw new ArgumentException("Valor no reconocido en archivo configuración, parámetro 'POS', valor encontrado {pos}.", tipoPOS),
        };
    }
    }
