using gatewayGK.ComandosGk;
using GatewaySCO;
using Serilog;

/// <summary>
/// Instancia directorio de comandos de GK Smart POS con cada
/// uno de los comandos.
/// </summary>
public class DispensaDirectorioCmdsGK : IDispensaDirectorioCmds
{
    /// <summary>
    /// Retorna directorio de comandos instanciado y poblado de
    /// comandos. 
    /// </summary>
    public static CreaDirectorioCmds Dispensa()
    {
        Log.Information("Instancia comandos de GK Smart POS.");
        return new IniciaDirectorioCmds()
            //.AgregaCmd(new Gk.InitializeRequestCmd())
            .AgregaCmd(new InitializeRequestCmdGk())
            .AgregaCmd(new QueryStatusRequestCmdGk())
            .AgregaCmd(new ReportStatusEventsRequestCmdGk())
            .AgregaCmd(new AddItemRequestCmdGk())
            .DirectorioCmds;
    }
}