using EvaPosSrvDTO;
using EvaPosSrvResp;
/// <summary>
/// Interface de definición de comandos.
/// </summary>
public interface IComando
    {
        /// <summary>
        /// Identifica el mensaje al cual el comando responde.
        /// La referencia es usada por el servidor de mensajes para asociar 
        /// un tipo de mensaje con el comando respectivo.
        /// La referencia corresponde a un string contenido en el mensaje
        /// que permite identificar su tipo.
        /// </summary>
        public string Referencia { get; set; }

        /// <summary>
        /// Carga el DTO con los datos a procesar.
        /// Este método debe ser invocado antes de ejecutar el comando,
        /// para inicializarlo con los datos necesarios para ejecutar.
        /// </summary>
        public void CargaDTO(DTOBase dto);

        /// <summary>
        /// Ejecuta el comando, retorna objeto DTO de respuesta.
        /// </summary>
        public Respuestas Ejecutar();

        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IComando CreaCopia();
    }