using System.Text.Json.Serialization;

namespace SCOGateway.POSGk
{
    /// <summary>
    /// Registro para solicitar autenticación a cliente Smart POS GK.
    /// </summary>
    public class LoginRequestWrapper
    {
        [JsonPropertyName("com.gk_software.pos.api.service.session.LoginRequest")]
        public AutenticationReq LoginRequest { get; set; }
    }
    public record AutenticationReq
    {
        [JsonPropertyName("retailStoreId")]
        public string RetailStoreId { get; set; } = "";

        [JsonPropertyName("workstationId")]
        public string WorkstationId { get; set; } = "";

        [JsonPropertyName("workstationAddress")]
        public string WorkstationAddress { get; set; } = "";

        [JsonPropertyName("workstationTypeCode")]
        public string WorkstationTypeCode { get; set; } = "";

        [JsonPropertyName("loginName")]
        public string LoginName { get; set; } = "";

        [JsonPropertyName("tillId")]
        public Till TillId { get; set; } = new Till();

        [JsonPropertyName("password")]
        public string Password { get; set; } = "";

        [JsonPropertyName("trainingMode")]
        public bool TrainingMode { get; set; } = false;

        [JsonPropertyName("finalizeControlTransactionFlag")]
        public bool FinalizeControlTransactionFlag { get; set; } = false;

        [JsonPropertyName("useLoginTypeTechnicalForLoginManager")]
        public bool UseLoginTypeTechnicalForLoginManager { get; set; } = false;
    }

    public record Till
    {
        [JsonPropertyName("com.gk_software.pos.api.model.dom.app.services.transaction.TillDoKey")]
        public TillDoKey TillDoKey { get; set; } = new TillDoKey();
    }

    public record TillDoKey
    {
        [JsonPropertyName("businessUnitGroupID")]
        public string BusinessUnitGroupID { get; set; } = "";

        [JsonPropertyName("tillID")]
        public string TillID { get; set; } = "";
    }
}