/// <summary>
/// Esta clase almacena valores requeridos
/// para la operación del SCO con la operación de la POS GK,
/// valores que deben ser compartidos entre comandos.
/// </summary>
public class EntornoGK
{
    /// <summary>
    /// Gk - seguridad usuario.
    /// </summary>
    public string RealmId { get; set; } = "";

    /// <summary>
    /// Gk - días expiración realmId.
    /// </summary>
    public int ExpirationCountDays { get; set; } = 0;

    public string TransactionID { get; set; } = "";

    public string SessionId { get; set; } = "";
    public string posSessionId { get; set; } = "";
    /// <summary>
    /// Gk - BusinessUnitGroupID requerido para request a Smart Pos en transacciones
    /// asociadas a venta.
    /// </summary>
    public string BusinessUnitGroupID { get; set; } = "";

    /// <summary>
    /// Número de secuencia de la transacción, usado en la suspención de transacción.
    /// </summary>
    private int _sequenceNumber = 0;
    public int SequenceNumber
    {
        get => _sequenceNumber;
        set
        {
            _sequenceNumber = value;
            SuspendNumber = DateTime.Now.ToString("0ddHHmmss") + SequenceNumber.ToString().PadLeft(6, '0');
        }
    }

    /// <summary>
    /// Número de referencia para la suspención de transacción.
    /// </summary>
    public string SuspendNumber { get; set; } = "";
    


    /// <summary>
    /// GK Language.
    /// </summary>
    public string Language { get; set; } = "en";

    private string? _urlBase;
    private ConfigGk? _configGk;

    /// <summary>
    /// Parámetros de configuración Gk Smart POS.
    /// Inicializados desde el archivo de configuración.
    /// </summary>
    public ConfigGk ConfigGk
    {
        get => _configGk ?? throw new ApplicationException("ConfigGk no definido.");
        set
        {
            _configGk = value;
            _urlBase = $"https://{value.IpGkSmartPOS}:{value.PortGkSmartPOS}/smartpos-service/tenants/{value.TenantId}/services";
        }
    }

    /// <summary>
    /// Url base de servicios Gk Smart POS.
    /// </summary>
    public string UrlBase
    {
        get => _urlBase ?? throw new ApplicationException("UrlBase no inicializada.");
        private set { }
    }
}