/* 
 * GK application - OmniPOS Service API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 5.21.1-b03
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// CreateLayawayConfig &lt;p&gt;This configuration entity defines the create layaway process.&lt;/p&gt;
    /// </summary>
    [DataContract]
    public partial class ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig :  IEquatable<ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig" /> class.
        /// </summary>
        /// <param name="processId">&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt; (required).</param>
        /// <param name="mainProcess">&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;.</param>
        /// <param name="authorizationConfig">&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;.</param>
        /// <param name="allowedItemNrEanList">&lt;p&gt;The parameter defines a list of item numbers/ EANs  (ItemID | POSItemID | MainPOSItemID) of the items, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined items are separated by semicolons &#39;;&#39;.&lt;/p&gt;.</param>
        /// <param name="allowedMhgList">&lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined merchandise hierarchy groups IDs are separated by semicolons &#39;;&#39;.&lt;/p&gt;.</param>
        /// <param name="initialDownPayment">&lt;p&gt;The parameter defines the initial down payment amount in %.&lt;/p&gt; (required).</param>
        /// <param name="initialFixAmount">&lt;p&gt;The parameter defines the initial down payment amount as a fix amount in main currency.&lt;/p&gt; (required).</param>
        /// <param name="layawayValidDays">&lt;p&gt;The parameter defines the validation time of the Layaway in days to calculate the final payment date based on the current date.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: Date of today &#x3D; 13.02.2018, layawayValidDays &#x3D; 28, final payment date &#x3D; 13.03.2018&lt;/p&gt; (required).</param>
        /// <param name="layawayValidDate">&lt;p&gt;The parameter defines the validation date of the Layaway independent from the creation date of the layaway. If this parameter &amp;lt;&amp;gt; null, the value of parameter layawayValidDays is not used.&lt;br /&gt; Format: YYYY-MM-DD, e.g.: 2019-09-27&lt;br /&gt; Example: &lt;br /&gt; Date of today &#x3D; 01.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;br /&gt; Date of today &#x3D; 03.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;/p&gt;.</param>
        /// <param name="paymentDays">&lt;p&gt;The parameter defines every how many days a payment should be done, e.g. every 7 days or every 14 days&lt;br /&gt; Example: Date of today &#x3D; 13.02.2018, paymentDays&#x3D;7, pament dates &#x3D; 20.02.2018, 27.02.2018, 06.03.2018, 13.03.2018&lt;/p&gt; (required).</param>
        /// <param name="toleranceTime">&lt;p&gt;The parameter defines how many days the final payment rate can be paid later than expected to calculate the latest final payment date.&lt;br /&gt; If the tolerance time is exceeded, the Layaway is canceled and the item goes back to the Store Stock.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final payment date &#x3D; 13.03.2018, toleranceTime &#x3D; 3, latest final payment date &#x3D; 16.03.2018&lt;/p&gt; (required).</param>
        /// <param name="deletingTime">&lt;p&gt;The parameter defines after how many days, beginning from the final expiration date (LatestFinalPaymentDate), the Layaway can be deleted. If the deleting time is exceeded, no actions (also no retrieving money from expired Layaway) can be performed.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final expiration date &#x3D; 01.03.2018, deletingTime &#x3D; 200, deleting date &#x3D; 17.09.2018&lt;/p&gt; (required).</param>
        /// <param name="serviceFeePercent">&lt;p&gt;The parameter defines the Service Fee in %.&lt;/p&gt; (required).</param>
        /// <param name="serviceFeeAmount">&lt;p&gt;The parameter defines the Amount of the Service Fee.&lt;/p&gt; (required).</param>
        /// <param name="cancellationFeePercent">&lt;p&gt;The parameter defines the Cancellation Fee in % which is calculated, if the Layaway is voided.&lt;/p&gt; (required).</param>
        /// <param name="cancellationFeeAmount">&lt;p&gt;The parameter defines the Amount of the Cancellation Fee which is calculated, if the Layaway is voided.&lt;/p&gt; (required).</param>
        /// <param name="penaltyFeePercent">&lt;p&gt;The parameter defines the percentage from the total layaway amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt; (required).</param>
        /// <param name="penaltyFeeAmount">&lt;p&gt;The parameter defines the fixed amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt; (required).</param>
        /// <param name="feeTaxGroupId">&lt;p&gt;The parameter defines the tax group of the several fees.&lt;/p&gt;.</param>
        /// <param name="customerIdentificationConfig">&lt;p&gt;Config for customer identification sub process&lt;/p&gt; (required).</param>
        /// <param name="positionOperationConfig">&lt;p&gt;Config for positionOperationConfig&lt;/p&gt; (required).</param>
        /// <param name="xXCustom08">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom10">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom09">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom07">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom05">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom06">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom11">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom12">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom13">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom14">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom15">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom03">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom02">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom04">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom01">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        public ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig(string processId = default(string), bool? mainProcess = default(bool?), ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig authorizationConfig = default(ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig), string allowedItemNrEanList = default(string), string allowedMhgList = default(string), double? initialDownPayment = default(double?), double? initialFixAmount = default(double?), int? layawayValidDays = default(int?), string layawayValidDate = default(string), int? paymentDays = default(int?), int? toleranceTime = default(int?), int? deletingTime = default(int?), double? serviceFeePercent = default(double?), double? serviceFeeAmount = default(double?), double? cancellationFeePercent = default(double?), double? cancellationFeeAmount = default(double?), double? penaltyFeePercent = default(double?), double? penaltyFeeAmount = default(double?), string feeTaxGroupId = default(string), ComGkSoftwarePosApiModelConfigProcessFlowsCustomerIdentificationConfig customerIdentificationConfig = default(ComGkSoftwarePosApiModelConfigProcessFlowsCustomerIdentificationConfig), ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig positionOperationConfig = default(ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig), string xXCustom08 = default(string), string xXCustom10 = default(string), string xXCustom09 = default(string), string xXCustom07 = default(string), string xXCustom05 = default(string), string xXCustom06 = default(string), string xXCustom11 = default(string), string xXCustom12 = default(string), string xXCustom13 = default(string), string xXCustom14 = default(string), string xXCustom15 = default(string), string xXCustom03 = default(string), string xXCustom02 = default(string), string xXCustom04 = default(string), string xXCustom01 = default(string))
        {
            // to ensure "processId" is required (not null)
            if (processId == null)
            {
                throw new InvalidDataException("processId is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.ProcessId = processId;
            }
            // to ensure "initialDownPayment" is required (not null)
            if (initialDownPayment == null)
            {
                throw new InvalidDataException("initialDownPayment is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.InitialDownPayment = initialDownPayment;
            }
            // to ensure "initialFixAmount" is required (not null)
            if (initialFixAmount == null)
            {
                throw new InvalidDataException("initialFixAmount is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.InitialFixAmount = initialFixAmount;
            }
            // to ensure "layawayValidDays" is required (not null)
            if (layawayValidDays == null)
            {
                throw new InvalidDataException("layawayValidDays is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.LayawayValidDays = layawayValidDays;
            }
            // to ensure "paymentDays" is required (not null)
            if (paymentDays == null)
            {
                throw new InvalidDataException("paymentDays is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.PaymentDays = paymentDays;
            }
            // to ensure "toleranceTime" is required (not null)
            if (toleranceTime == null)
            {
                throw new InvalidDataException("toleranceTime is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.ToleranceTime = toleranceTime;
            }
            // to ensure "deletingTime" is required (not null)
            if (deletingTime == null)
            {
                throw new InvalidDataException("deletingTime is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.DeletingTime = deletingTime;
            }
            // to ensure "serviceFeePercent" is required (not null)
            if (serviceFeePercent == null)
            {
                throw new InvalidDataException("serviceFeePercent is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.ServiceFeePercent = serviceFeePercent;
            }
            // to ensure "serviceFeeAmount" is required (not null)
            if (serviceFeeAmount == null)
            {
                throw new InvalidDataException("serviceFeeAmount is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.ServiceFeeAmount = serviceFeeAmount;
            }
            // to ensure "cancellationFeePercent" is required (not null)
            if (cancellationFeePercent == null)
            {
                throw new InvalidDataException("cancellationFeePercent is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.CancellationFeePercent = cancellationFeePercent;
            }
            // to ensure "cancellationFeeAmount" is required (not null)
            if (cancellationFeeAmount == null)
            {
                throw new InvalidDataException("cancellationFeeAmount is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.CancellationFeeAmount = cancellationFeeAmount;
            }
            // to ensure "penaltyFeePercent" is required (not null)
            if (penaltyFeePercent == null)
            {
                throw new InvalidDataException("penaltyFeePercent is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.PenaltyFeePercent = penaltyFeePercent;
            }
            // to ensure "penaltyFeeAmount" is required (not null)
            if (penaltyFeeAmount == null)
            {
                throw new InvalidDataException("penaltyFeeAmount is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.PenaltyFeeAmount = penaltyFeeAmount;
            }
            // to ensure "customerIdentificationConfig" is required (not null)
            if (customerIdentificationConfig == null)
            {
                throw new InvalidDataException("customerIdentificationConfig is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.CustomerIdentificationConfig = customerIdentificationConfig;
            }
            // to ensure "positionOperationConfig" is required (not null)
            if (positionOperationConfig == null)
            {
                throw new InvalidDataException("positionOperationConfig is a required property for ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig and cannot be null");
            }
            else
            {
                this.PositionOperationConfig = positionOperationConfig;
            }
            this.MainProcess = mainProcess;
            this.AuthorizationConfig = authorizationConfig;
            this.AllowedItemNrEanList = allowedItemNrEanList;
            this.AllowedMhgList = allowedMhgList;
            this.LayawayValidDate = layawayValidDate;
            this.FeeTaxGroupId = feeTaxGroupId;
            this.XXCustom08 = xXCustom08;
            this.XXCustom10 = xXCustom10;
            this.XXCustom09 = xXCustom09;
            this.XXCustom07 = xXCustom07;
            this.XXCustom05 = xXCustom05;
            this.XXCustom06 = xXCustom06;
            this.XXCustom11 = xXCustom11;
            this.XXCustom12 = xXCustom12;
            this.XXCustom13 = xXCustom13;
            this.XXCustom14 = xXCustom14;
            this.XXCustom15 = xXCustom15;
            this.XXCustom03 = xXCustom03;
            this.XXCustom02 = xXCustom02;
            this.XXCustom04 = xXCustom04;
            this.XXCustom01 = xXCustom01;
        }
        
        /// <summary>
        /// &lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;</value>
        [DataMember(Name="processId", EmitDefaultValue=false)]
        public string ProcessId { get; set; }

        /// <summary>
        /// &lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;</value>
        [DataMember(Name="mainProcess", EmitDefaultValue=false)]
        public bool? MainProcess { get; set; }

        /// <summary>
        /// &lt;p&gt;This config defines authorization related processes.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;</value>
        [DataMember(Name="authorizationConfig", EmitDefaultValue=false)]
        public ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig AuthorizationConfig { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines a list of item numbers/ EANs  (ItemID | POSItemID | MainPOSItemID) of the items, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined items are separated by semicolons &#39;;&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines a list of item numbers/ EANs  (ItemID | POSItemID | MainPOSItemID) of the items, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined items are separated by semicolons &#39;;&#39;.&lt;/p&gt;</value>
        [DataMember(Name="allowedItemNrEanList", EmitDefaultValue=false)]
        public string AllowedItemNrEanList { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined merchandise hierarchy groups IDs are separated by semicolons &#39;;&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined merchandise hierarchy groups IDs are separated by semicolons &#39;;&#39;.&lt;/p&gt;</value>
        [DataMember(Name="allowedMhgList", EmitDefaultValue=false)]
        public string AllowedMhgList { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the initial down payment amount in %.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the initial down payment amount in %.&lt;/p&gt;</value>
        [DataMember(Name="initialDownPayment", EmitDefaultValue=false)]
        public double? InitialDownPayment { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the initial down payment amount as a fix amount in main currency.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the initial down payment amount as a fix amount in main currency.&lt;/p&gt;</value>
        [DataMember(Name="initialFixAmount", EmitDefaultValue=false)]
        public double? InitialFixAmount { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the validation time of the Layaway in days to calculate the final payment date based on the current date.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: Date of today &#x3D; 13.02.2018, layawayValidDays &#x3D; 28, final payment date &#x3D; 13.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the validation time of the Layaway in days to calculate the final payment date based on the current date.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: Date of today &#x3D; 13.02.2018, layawayValidDays &#x3D; 28, final payment date &#x3D; 13.03.2018&lt;/p&gt;</value>
        [DataMember(Name="layawayValidDays", EmitDefaultValue=false)]
        public int? LayawayValidDays { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the validation date of the Layaway independent from the creation date of the layaway. If this parameter &amp;lt;&amp;gt; null, the value of parameter layawayValidDays is not used.&lt;br /&gt; Format: YYYY-MM-DD, e.g.: 2019-09-27&lt;br /&gt; Example: &lt;br /&gt; Date of today &#x3D; 01.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;br /&gt; Date of today &#x3D; 03.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the validation date of the Layaway independent from the creation date of the layaway. If this parameter &amp;lt;&amp;gt; null, the value of parameter layawayValidDays is not used.&lt;br /&gt; Format: YYYY-MM-DD, e.g.: 2019-09-27&lt;br /&gt; Example: &lt;br /&gt; Date of today &#x3D; 01.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;br /&gt; Date of today &#x3D; 03.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;/p&gt;</value>
        [DataMember(Name="layawayValidDate", EmitDefaultValue=false)]
        public string LayawayValidDate { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines every how many days a payment should be done, e.g. every 7 days or every 14 days&lt;br /&gt; Example: Date of today &#x3D; 13.02.2018, paymentDays&#x3D;7, pament dates &#x3D; 20.02.2018, 27.02.2018, 06.03.2018, 13.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines every how many days a payment should be done, e.g. every 7 days or every 14 days&lt;br /&gt; Example: Date of today &#x3D; 13.02.2018, paymentDays&#x3D;7, pament dates &#x3D; 20.02.2018, 27.02.2018, 06.03.2018, 13.03.2018&lt;/p&gt;</value>
        [DataMember(Name="paymentDays", EmitDefaultValue=false)]
        public int? PaymentDays { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines how many days the final payment rate can be paid later than expected to calculate the latest final payment date.&lt;br /&gt; If the tolerance time is exceeded, the Layaway is canceled and the item goes back to the Store Stock.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final payment date &#x3D; 13.03.2018, toleranceTime &#x3D; 3, latest final payment date &#x3D; 16.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines how many days the final payment rate can be paid later than expected to calculate the latest final payment date.&lt;br /&gt; If the tolerance time is exceeded, the Layaway is canceled and the item goes back to the Store Stock.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final payment date &#x3D; 13.03.2018, toleranceTime &#x3D; 3, latest final payment date &#x3D; 16.03.2018&lt;/p&gt;</value>
        [DataMember(Name="toleranceTime", EmitDefaultValue=false)]
        public int? ToleranceTime { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines after how many days, beginning from the final expiration date (LatestFinalPaymentDate), the Layaway can be deleted. If the deleting time is exceeded, no actions (also no retrieving money from expired Layaway) can be performed.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final expiration date &#x3D; 01.03.2018, deletingTime &#x3D; 200, deleting date &#x3D; 17.09.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines after how many days, beginning from the final expiration date (LatestFinalPaymentDate), the Layaway can be deleted. If the deleting time is exceeded, no actions (also no retrieving money from expired Layaway) can be performed.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final expiration date &#x3D; 01.03.2018, deletingTime &#x3D; 200, deleting date &#x3D; 17.09.2018&lt;/p&gt;</value>
        [DataMember(Name="deletingTime", EmitDefaultValue=false)]
        public int? DeletingTime { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the Service Fee in %.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Service Fee in %.&lt;/p&gt;</value>
        [DataMember(Name="serviceFeePercent", EmitDefaultValue=false)]
        public double? ServiceFeePercent { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the Amount of the Service Fee.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Amount of the Service Fee.&lt;/p&gt;</value>
        [DataMember(Name="serviceFeeAmount", EmitDefaultValue=false)]
        public double? ServiceFeeAmount { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the Cancellation Fee in % which is calculated, if the Layaway is voided.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Cancellation Fee in % which is calculated, if the Layaway is voided.&lt;/p&gt;</value>
        [DataMember(Name="cancellationFeePercent", EmitDefaultValue=false)]
        public double? CancellationFeePercent { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the Amount of the Cancellation Fee which is calculated, if the Layaway is voided.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Amount of the Cancellation Fee which is calculated, if the Layaway is voided.&lt;/p&gt;</value>
        [DataMember(Name="cancellationFeeAmount", EmitDefaultValue=false)]
        public double? CancellationFeeAmount { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the percentage from the total layaway amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the percentage from the total layaway amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;</value>
        [DataMember(Name="penaltyFeePercent", EmitDefaultValue=false)]
        public double? PenaltyFeePercent { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the fixed amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the fixed amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;</value>
        [DataMember(Name="penaltyFeeAmount", EmitDefaultValue=false)]
        public double? PenaltyFeeAmount { get; set; }

        /// <summary>
        /// &lt;p&gt;The parameter defines the tax group of the several fees.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the tax group of the several fees.&lt;/p&gt;</value>
        [DataMember(Name="feeTaxGroupId", EmitDefaultValue=false)]
        public string FeeTaxGroupId { get; set; }

        /// <summary>
        /// &lt;p&gt;Config for customer identification sub process&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Config for customer identification sub process&lt;/p&gt;</value>
        [DataMember(Name="customerIdentificationConfig", EmitDefaultValue=false)]
        public ComGkSoftwarePosApiModelConfigProcessFlowsCustomerIdentificationConfig CustomerIdentificationConfig { get; set; }

        /// <summary>
        /// &lt;p&gt;Config for positionOperationConfig&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Config for positionOperationConfig&lt;/p&gt;</value>
        [DataMember(Name="positionOperationConfig", EmitDefaultValue=false)]
        public ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig PositionOperationConfig { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom08", EmitDefaultValue=false)]
        public string XXCustom08 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom10", EmitDefaultValue=false)]
        public string XXCustom10 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom09", EmitDefaultValue=false)]
        public string XXCustom09 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom07", EmitDefaultValue=false)]
        public string XXCustom07 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom05", EmitDefaultValue=false)]
        public string XXCustom05 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom06", EmitDefaultValue=false)]
        public string XXCustom06 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom11", EmitDefaultValue=false)]
        public string XXCustom11 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom12", EmitDefaultValue=false)]
        public string XXCustom12 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom13", EmitDefaultValue=false)]
        public string XXCustom13 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom14", EmitDefaultValue=false)]
        public string XXCustom14 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom15", EmitDefaultValue=false)]
        public string XXCustom15 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom03", EmitDefaultValue=false)]
        public string XXCustom03 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom02", EmitDefaultValue=false)]
        public string XXCustom02 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom04", EmitDefaultValue=false)]
        public string XXCustom04 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom01", EmitDefaultValue=false)]
        public string XXCustom01 { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig {\n");
            sb.Append("  ProcessId: ").Append(ProcessId).Append("\n");
            sb.Append("  MainProcess: ").Append(MainProcess).Append("\n");
            sb.Append("  AuthorizationConfig: ").Append(AuthorizationConfig).Append("\n");
            sb.Append("  AllowedItemNrEanList: ").Append(AllowedItemNrEanList).Append("\n");
            sb.Append("  AllowedMhgList: ").Append(AllowedMhgList).Append("\n");
            sb.Append("  InitialDownPayment: ").Append(InitialDownPayment).Append("\n");
            sb.Append("  InitialFixAmount: ").Append(InitialFixAmount).Append("\n");
            sb.Append("  LayawayValidDays: ").Append(LayawayValidDays).Append("\n");
            sb.Append("  LayawayValidDate: ").Append(LayawayValidDate).Append("\n");
            sb.Append("  PaymentDays: ").Append(PaymentDays).Append("\n");
            sb.Append("  ToleranceTime: ").Append(ToleranceTime).Append("\n");
            sb.Append("  DeletingTime: ").Append(DeletingTime).Append("\n");
            sb.Append("  ServiceFeePercent: ").Append(ServiceFeePercent).Append("\n");
            sb.Append("  ServiceFeeAmount: ").Append(ServiceFeeAmount).Append("\n");
            sb.Append("  CancellationFeePercent: ").Append(CancellationFeePercent).Append("\n");
            sb.Append("  CancellationFeeAmount: ").Append(CancellationFeeAmount).Append("\n");
            sb.Append("  PenaltyFeePercent: ").Append(PenaltyFeePercent).Append("\n");
            sb.Append("  PenaltyFeeAmount: ").Append(PenaltyFeeAmount).Append("\n");
            sb.Append("  FeeTaxGroupId: ").Append(FeeTaxGroupId).Append("\n");
            sb.Append("  CustomerIdentificationConfig: ").Append(CustomerIdentificationConfig).Append("\n");
            sb.Append("  PositionOperationConfig: ").Append(PositionOperationConfig).Append("\n");
            sb.Append("  XXCustom08: ").Append(XXCustom08).Append("\n");
            sb.Append("  XXCustom10: ").Append(XXCustom10).Append("\n");
            sb.Append("  XXCustom09: ").Append(XXCustom09).Append("\n");
            sb.Append("  XXCustom07: ").Append(XXCustom07).Append("\n");
            sb.Append("  XXCustom05: ").Append(XXCustom05).Append("\n");
            sb.Append("  XXCustom06: ").Append(XXCustom06).Append("\n");
            sb.Append("  XXCustom11: ").Append(XXCustom11).Append("\n");
            sb.Append("  XXCustom12: ").Append(XXCustom12).Append("\n");
            sb.Append("  XXCustom13: ").Append(XXCustom13).Append("\n");
            sb.Append("  XXCustom14: ").Append(XXCustom14).Append("\n");
            sb.Append("  XXCustom15: ").Append(XXCustom15).Append("\n");
            sb.Append("  XXCustom03: ").Append(XXCustom03).Append("\n");
            sb.Append("  XXCustom02: ").Append(XXCustom02).Append("\n");
            sb.Append("  XXCustom04: ").Append(XXCustom04).Append("\n");
            sb.Append("  XXCustom01: ").Append(XXCustom01).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig);
        }

        /// <summary>
        /// Returns true if ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig instances are equal
        /// </summary>
        /// <param name="input">Instance of ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ComGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.ProcessId == input.ProcessId ||
                    (this.ProcessId != null &&
                    this.ProcessId.Equals(input.ProcessId))
                ) && 
                (
                    this.MainProcess == input.MainProcess ||
                    (this.MainProcess != null &&
                    this.MainProcess.Equals(input.MainProcess))
                ) && 
                (
                    this.AuthorizationConfig == input.AuthorizationConfig ||
                    (this.AuthorizationConfig != null &&
                    this.AuthorizationConfig.Equals(input.AuthorizationConfig))
                ) && 
                (
                    this.AllowedItemNrEanList == input.AllowedItemNrEanList ||
                    (this.AllowedItemNrEanList != null &&
                    this.AllowedItemNrEanList.Equals(input.AllowedItemNrEanList))
                ) && 
                (
                    this.AllowedMhgList == input.AllowedMhgList ||
                    (this.AllowedMhgList != null &&
                    this.AllowedMhgList.Equals(input.AllowedMhgList))
                ) && 
                (
                    this.InitialDownPayment == input.InitialDownPayment ||
                    (this.InitialDownPayment != null &&
                    this.InitialDownPayment.Equals(input.InitialDownPayment))
                ) && 
                (
                    this.InitialFixAmount == input.InitialFixAmount ||
                    (this.InitialFixAmount != null &&
                    this.InitialFixAmount.Equals(input.InitialFixAmount))
                ) && 
                (
                    this.LayawayValidDays == input.LayawayValidDays ||
                    (this.LayawayValidDays != null &&
                    this.LayawayValidDays.Equals(input.LayawayValidDays))
                ) && 
                (
                    this.LayawayValidDate == input.LayawayValidDate ||
                    (this.LayawayValidDate != null &&
                    this.LayawayValidDate.Equals(input.LayawayValidDate))
                ) && 
                (
                    this.PaymentDays == input.PaymentDays ||
                    (this.PaymentDays != null &&
                    this.PaymentDays.Equals(input.PaymentDays))
                ) && 
                (
                    this.ToleranceTime == input.ToleranceTime ||
                    (this.ToleranceTime != null &&
                    this.ToleranceTime.Equals(input.ToleranceTime))
                ) && 
                (
                    this.DeletingTime == input.DeletingTime ||
                    (this.DeletingTime != null &&
                    this.DeletingTime.Equals(input.DeletingTime))
                ) && 
                (
                    this.ServiceFeePercent == input.ServiceFeePercent ||
                    (this.ServiceFeePercent != null &&
                    this.ServiceFeePercent.Equals(input.ServiceFeePercent))
                ) && 
                (
                    this.ServiceFeeAmount == input.ServiceFeeAmount ||
                    (this.ServiceFeeAmount != null &&
                    this.ServiceFeeAmount.Equals(input.ServiceFeeAmount))
                ) && 
                (
                    this.CancellationFeePercent == input.CancellationFeePercent ||
                    (this.CancellationFeePercent != null &&
                    this.CancellationFeePercent.Equals(input.CancellationFeePercent))
                ) && 
                (
                    this.CancellationFeeAmount == input.CancellationFeeAmount ||
                    (this.CancellationFeeAmount != null &&
                    this.CancellationFeeAmount.Equals(input.CancellationFeeAmount))
                ) && 
                (
                    this.PenaltyFeePercent == input.PenaltyFeePercent ||
                    (this.PenaltyFeePercent != null &&
                    this.PenaltyFeePercent.Equals(input.PenaltyFeePercent))
                ) && 
                (
                    this.PenaltyFeeAmount == input.PenaltyFeeAmount ||
                    (this.PenaltyFeeAmount != null &&
                    this.PenaltyFeeAmount.Equals(input.PenaltyFeeAmount))
                ) && 
                (
                    this.FeeTaxGroupId == input.FeeTaxGroupId ||
                    (this.FeeTaxGroupId != null &&
                    this.FeeTaxGroupId.Equals(input.FeeTaxGroupId))
                ) && 
                (
                    this.CustomerIdentificationConfig == input.CustomerIdentificationConfig ||
                    (this.CustomerIdentificationConfig != null &&
                    this.CustomerIdentificationConfig.Equals(input.CustomerIdentificationConfig))
                ) && 
                (
                    this.PositionOperationConfig == input.PositionOperationConfig ||
                    (this.PositionOperationConfig != null &&
                    this.PositionOperationConfig.Equals(input.PositionOperationConfig))
                ) && 
                (
                    this.XXCustom08 == input.XXCustom08 ||
                    (this.XXCustom08 != null &&
                    this.XXCustom08.Equals(input.XXCustom08))
                ) && 
                (
                    this.XXCustom10 == input.XXCustom10 ||
                    (this.XXCustom10 != null &&
                    this.XXCustom10.Equals(input.XXCustom10))
                ) && 
                (
                    this.XXCustom09 == input.XXCustom09 ||
                    (this.XXCustom09 != null &&
                    this.XXCustom09.Equals(input.XXCustom09))
                ) && 
                (
                    this.XXCustom07 == input.XXCustom07 ||
                    (this.XXCustom07 != null &&
                    this.XXCustom07.Equals(input.XXCustom07))
                ) && 
                (
                    this.XXCustom05 == input.XXCustom05 ||
                    (this.XXCustom05 != null &&
                    this.XXCustom05.Equals(input.XXCustom05))
                ) && 
                (
                    this.XXCustom06 == input.XXCustom06 ||
                    (this.XXCustom06 != null &&
                    this.XXCustom06.Equals(input.XXCustom06))
                ) && 
                (
                    this.XXCustom11 == input.XXCustom11 ||
                    (this.XXCustom11 != null &&
                    this.XXCustom11.Equals(input.XXCustom11))
                ) && 
                (
                    this.XXCustom12 == input.XXCustom12 ||
                    (this.XXCustom12 != null &&
                    this.XXCustom12.Equals(input.XXCustom12))
                ) && 
                (
                    this.XXCustom13 == input.XXCustom13 ||
                    (this.XXCustom13 != null &&
                    this.XXCustom13.Equals(input.XXCustom13))
                ) && 
                (
                    this.XXCustom14 == input.XXCustom14 ||
                    (this.XXCustom14 != null &&
                    this.XXCustom14.Equals(input.XXCustom14))
                ) && 
                (
                    this.XXCustom15 == input.XXCustom15 ||
                    (this.XXCustom15 != null &&
                    this.XXCustom15.Equals(input.XXCustom15))
                ) && 
                (
                    this.XXCustom03 == input.XXCustom03 ||
                    (this.XXCustom03 != null &&
                    this.XXCustom03.Equals(input.XXCustom03))
                ) && 
                (
                    this.XXCustom02 == input.XXCustom02 ||
                    (this.XXCustom02 != null &&
                    this.XXCustom02.Equals(input.XXCustom02))
                ) && 
                (
                    this.XXCustom04 == input.XXCustom04 ||
                    (this.XXCustom04 != null &&
                    this.XXCustom04.Equals(input.XXCustom04))
                ) && 
                (
                    this.XXCustom01 == input.XXCustom01 ||
                    (this.XXCustom01 != null &&
                    this.XXCustom01.Equals(input.XXCustom01))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.ProcessId != null)
                    hashCode = hashCode * 59 + this.ProcessId.GetHashCode();
                if (this.MainProcess != null)
                    hashCode = hashCode * 59 + this.MainProcess.GetHashCode();
                if (this.AuthorizationConfig != null)
                    hashCode = hashCode * 59 + this.AuthorizationConfig.GetHashCode();
                if (this.AllowedItemNrEanList != null)
                    hashCode = hashCode * 59 + this.AllowedItemNrEanList.GetHashCode();
                if (this.AllowedMhgList != null)
                    hashCode = hashCode * 59 + this.AllowedMhgList.GetHashCode();
                if (this.InitialDownPayment != null)
                    hashCode = hashCode * 59 + this.InitialDownPayment.GetHashCode();
                if (this.InitialFixAmount != null)
                    hashCode = hashCode * 59 + this.InitialFixAmount.GetHashCode();
                if (this.LayawayValidDays != null)
                    hashCode = hashCode * 59 + this.LayawayValidDays.GetHashCode();
                if (this.LayawayValidDate != null)
                    hashCode = hashCode * 59 + this.LayawayValidDate.GetHashCode();
                if (this.PaymentDays != null)
                    hashCode = hashCode * 59 + this.PaymentDays.GetHashCode();
                if (this.ToleranceTime != null)
                    hashCode = hashCode * 59 + this.ToleranceTime.GetHashCode();
                if (this.DeletingTime != null)
                    hashCode = hashCode * 59 + this.DeletingTime.GetHashCode();
                if (this.ServiceFeePercent != null)
                    hashCode = hashCode * 59 + this.ServiceFeePercent.GetHashCode();
                if (this.ServiceFeeAmount != null)
                    hashCode = hashCode * 59 + this.ServiceFeeAmount.GetHashCode();
                if (this.CancellationFeePercent != null)
                    hashCode = hashCode * 59 + this.CancellationFeePercent.GetHashCode();
                if (this.CancellationFeeAmount != null)
                    hashCode = hashCode * 59 + this.CancellationFeeAmount.GetHashCode();
                if (this.PenaltyFeePercent != null)
                    hashCode = hashCode * 59 + this.PenaltyFeePercent.GetHashCode();
                if (this.PenaltyFeeAmount != null)
                    hashCode = hashCode * 59 + this.PenaltyFeeAmount.GetHashCode();
                if (this.FeeTaxGroupId != null)
                    hashCode = hashCode * 59 + this.FeeTaxGroupId.GetHashCode();
                if (this.CustomerIdentificationConfig != null)
                    hashCode = hashCode * 59 + this.CustomerIdentificationConfig.GetHashCode();
                if (this.PositionOperationConfig != null)
                    hashCode = hashCode * 59 + this.PositionOperationConfig.GetHashCode();
                if (this.XXCustom08 != null)
                    hashCode = hashCode * 59 + this.XXCustom08.GetHashCode();
                if (this.XXCustom10 != null)
                    hashCode = hashCode * 59 + this.XXCustom10.GetHashCode();
                if (this.XXCustom09 != null)
                    hashCode = hashCode * 59 + this.XXCustom09.GetHashCode();
                if (this.XXCustom07 != null)
                    hashCode = hashCode * 59 + this.XXCustom07.GetHashCode();
                if (this.XXCustom05 != null)
                    hashCode = hashCode * 59 + this.XXCustom05.GetHashCode();
                if (this.XXCustom06 != null)
                    hashCode = hashCode * 59 + this.XXCustom06.GetHashCode();
                if (this.XXCustom11 != null)
                    hashCode = hashCode * 59 + this.XXCustom11.GetHashCode();
                if (this.XXCustom12 != null)
                    hashCode = hashCode * 59 + this.XXCustom12.GetHashCode();
                if (this.XXCustom13 != null)
                    hashCode = hashCode * 59 + this.XXCustom13.GetHashCode();
                if (this.XXCustom14 != null)
                    hashCode = hashCode * 59 + this.XXCustom14.GetHashCode();
                if (this.XXCustom15 != null)
                    hashCode = hashCode * 59 + this.XXCustom15.GetHashCode();
                if (this.XXCustom03 != null)
                    hashCode = hashCode * 59 + this.XXCustom03.GetHashCode();
                if (this.XXCustom02 != null)
                    hashCode = hashCode * 59 + this.XXCustom02.GetHashCode();
                if (this.XXCustom04 != null)
                    hashCode = hashCode * 59 + this.XXCustom04.GetHashCode();
                if (this.XXCustom01 != null)
                    hashCode = hashCode * 59 + this.XXCustom01.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
