/* 
 * GK application - OmniPOS Service API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 5.21.1-b03
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// ExternalLineItemData &lt;p&gt;Manual line item creation with external data.&lt;/p&gt;
    /// </summary>
    [DataContract]
    public partial class ComGkSoftwarePosApiServiceTransactionExternalLineItemData :  IEquatable<ComGkSoftwarePosApiServiceTransactionExternalLineItemData>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiServiceTransactionExternalLineItemData" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ComGkSoftwarePosApiServiceTransactionExternalLineItemData() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiServiceTransactionExternalLineItemData" /> class.
        /// </summary>
        /// <param name="posItemID">&lt;p&gt;The pos item ID - IdentityAlphaNumeric40.&lt;/p&gt;.</param>
        /// <param name="itemID">&lt;p&gt;The item ID - IdentityUUID.&lt;/p&gt;.</param>
        /// <param name="posDepartmentID">&lt;p&gt;The pos department ID - IdentityAlphaNumeric40.&lt;/p&gt;.</param>
        /// <param name="unitOfMeasureCode">&lt;p&gt;The unit of measure code - Code4&lt;/p&gt;.</param>
        /// <param name="itemType">&lt;p&gt;The item type - Code4&lt;/p&gt;.</param>
        /// <param name="regularUnitPrice">&lt;p&gt;The regular unit price - MoneyShortRetail&lt;/p&gt;.</param>
        /// <param name="regularUnitPriceQuantity">&lt;p&gt;The number of items the regular price is defined for, i.e. 3 for $1.00&lt;/p&gt;.</param>
        /// <param name="actualUnitPrice">&lt;p&gt;The actual unit price - MoneyShortRetail&lt;/p&gt; (required).</param>
        /// <param name="actualUnitPriceQuantity">&lt;p&gt;The number of items the actual price is defined for, i.e. 3 for $1.00&lt;/p&gt;.</param>
        /// <param name="quantity">&lt;p&gt;The quantity - QuantityIntegerGK&lt;/p&gt; (required).</param>
        /// <param name="units">&lt;p&gt;The units - Quantity&lt;/p&gt;.</param>
        /// <param name="quantityInputMethod">&lt;p&gt;The quantity input method - Code2&lt;/p&gt;.</param>
        /// <param name="length">&lt;p&gt;The length - Quantity&lt;/p&gt;.</param>
        /// <param name="width">&lt;p&gt;The width - Quantity&lt;/p&gt;.</param>
        /// <param name="height">&lt;p&gt;The height - Quantity&lt;/p&gt;.</param>
        /// <param name="receiptText">&lt;p&gt;The receipt text - NNameGK&lt;/p&gt; (required).</param>
        /// <param name="receiptDescription">&lt;p&gt;The receipt description - NDescriptionShortGK&lt;/p&gt;.</param>
        /// <param name="wicFlag">&lt;p&gt;The wic flag - BIT&lt;/p&gt;.</param>
        /// <param name="allowFoodStampFlag">&lt;p&gt;The allow food stamp flag -&amp;gt; BIT&lt;/p&gt;.</param>
        /// <param name="registrationNumber">&lt;p&gt;The registration number - DescriptionShort&lt;/p&gt;.</param>
        /// <param name="discountFlag">&lt;p&gt;The discount flag - BIT&lt;/p&gt;.</param>
        /// <param name="frequentShopperPointsEligibilityFlag">&lt;p&gt;The frequent shopper points eligibility flag - BIT&lt;/p&gt;.</param>
        /// <param name="discountTypeCode">&lt;p&gt;The discount type code - VARCHAR(1)&lt;/p&gt;.</param>
        /// <param name="priceChangeTypeCode">&lt;p&gt;The price change type code - Code2&lt;/p&gt;.</param>
        /// <param name="priceTypeCode">&lt;p&gt;The price type code - Code2&lt;/p&gt;.</param>
        /// <param name="notConsideredByLoyaltyEngineFlag">&lt;p&gt;The not considered by loyalty engine flag - BIT&lt;/p&gt;.</param>
        /// <param name="merchandiseHierarchyGroupName">&lt;p&gt;The merchandise hierarchy group name - Name&lt;/p&gt;.</param>
        /// <param name="merchandiseHierarchyGroupDescription">&lt;p&gt;The merchandise hierarchy group description - DescriptionShort&lt;/p&gt;.</param>
        /// <param name="itemClassCode">&lt;p&gt;The PosUOMItemDO class code.&lt;/p&gt;.</param>
        /// <param name="prohibitTaxExemptFlag">&lt;p&gt;The prohibit tax exempt flag - BIT&lt;/p&gt;.</param>
        /// <param name="prohibitReturnFlag">&lt;p&gt;The prohibit return flag - BIT&lt;/p&gt;.</param>
        /// <param name="warrantyDuration">&lt;p&gt;The warranty duration - QuantityTransactionCount&lt;/p&gt;.</param>
        /// <param name="depositTypeCode">&lt;p&gt;The deposit type code - Code2&lt;/p&gt;.</param>
        /// <param name="taxExemptCode">&lt;p&gt;The tax exempt code - Code2&lt;/p&gt;.</param>
        /// <param name="mainPOSItemID">&lt;p&gt;The main POS item ID - IdentityGTIN&lt;/p&gt;.</param>
        /// <param name="mainMerchandiseHierarchyGroupIDQualifier">&lt;p&gt;The main merchandise hierarchy group ID qualifier - Code4&lt;/p&gt;.</param>
        /// <param name="mainMerchandiseHierarchyGroupID">&lt;p&gt;The main merchandise hierarchy group ID - IdentityAlphaNumeric40&lt;/p&gt;.</param>
        /// <param name="taxGroupID">&lt;p&gt;The tax group ID - Code&lt;/p&gt;.</param>
        /// <param name="tareCount">&lt;p&gt;The tare ount - Quantity16_3GK&lt;/p&gt;.</param>
        /// <param name="saleReturnLineItemCharacteristicList">&lt;p&gt;The sale return line item characteristic list - SaleReturnLineItemCharacteristic[0..*]&lt;/p&gt;.</param>
        /// <param name="saleReturnLineItemMerchandiseHierarchyGroupList">&lt;p&gt;The sale return line item merchandise hierarchy group list - SaleReturnLineItemMerchandiseHierarchyGroup[0..*]&lt;/p&gt;.</param>
        /// <param name="retailTransactionLineItemI18NTextList">&lt;p&gt;The retail transaction line item I18N text list - RetailTransactionLineItemI18NText[0..*]&lt;/p&gt;.</param>
        /// <param name="serializedUnitModifer">&lt;p&gt;The serialized unit modifer - SerializedUnitModifer&lt;/p&gt;.</param>
        /// <param name="saleReturnLineItemSalesOrder">&lt;p&gt;The sale return line item sales order - SaleReturnLineItemSalesOrder&lt;/p&gt;.</param>
        /// <param name="reasonCode">&lt;p&gt;The reason code&lt;/p&gt;.</param>
        /// <param name="reasonCodeGroupCode">&lt;p&gt;The reason code group code&lt;/p&gt;.</param>
        /// <param name="reasonDescription">&lt;p&gt;The reason description&lt;/p&gt;.</param>
        /// <param name="retailTransactionLineItemAdditionalParameterList">&lt;p&gt;The retail transaction line item additional parameter list&lt;/p&gt;.</param>
        /// <param name="retailPriceModifierList">&lt;p&gt;The retail price modifier list&lt;/p&gt;.</param>
        /// <param name="lineItemExtensionList">&lt;p&gt;The line item extension list&lt;/p&gt;.</param>
        /// <param name="printAdditionalLineItemTextLineList">&lt;p&gt;The print additional line item text line list&lt;/p&gt;.</param>
        public ComGkSoftwarePosApiServiceTransactionExternalLineItemData(string posItemID = default(string), string itemID = default(string), string posDepartmentID = default(string), string unitOfMeasureCode = default(string), string itemType = default(string), double? regularUnitPrice = default(double?), int? regularUnitPriceQuantity = default(int?), double? actualUnitPrice = default(double?), int? actualUnitPriceQuantity = default(int?), int? quantity = default(int?), double? units = default(double?), string quantityInputMethod = default(string), double? length = default(double?), double? width = default(double?), double? height = default(double?), string receiptText = default(string), string receiptDescription = default(string), bool? wicFlag = default(bool?), bool? allowFoodStampFlag = default(bool?), string registrationNumber = default(string), bool? discountFlag = default(bool?), bool? frequentShopperPointsEligibilityFlag = default(bool?), string discountTypeCode = default(string), string priceChangeTypeCode = default(string), string priceTypeCode = default(string), bool? notConsideredByLoyaltyEngineFlag = default(bool?), string merchandiseHierarchyGroupName = default(string), string merchandiseHierarchyGroupDescription = default(string), string itemClassCode = default(string), bool? prohibitTaxExemptFlag = default(bool?), bool? prohibitReturnFlag = default(bool?), double? warrantyDuration = default(double?), string depositTypeCode = default(string), string taxExemptCode = default(string), string mainPOSItemID = default(string), string mainMerchandiseHierarchyGroupIDQualifier = default(string), string mainMerchandiseHierarchyGroupID = default(string), string taxGroupID = default(string), double? tareCount = default(double?), List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemCharacteristic> saleReturnLineItemCharacteristicList = default(List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemCharacteristic>), List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemMerchandiseHierarchyGroup> saleReturnLineItemMerchandiseHierarchyGroupList = default(List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemMerchandiseHierarchyGroup>), List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemI18NText> retailTransactionLineItemI18NTextList = default(List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemI18NText>), ComGkSoftwarePosApiServiceTransactionSerializedUnitModifer serializedUnitModifer = default(ComGkSoftwarePosApiServiceTransactionSerializedUnitModifer), ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemSalesOrder saleReturnLineItemSalesOrder = default(ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemSalesOrder), string reasonCode = default(string), string reasonCodeGroupCode = default(string), string reasonDescription = default(string), List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemAdditionalParameter> retailTransactionLineItemAdditionalParameterList = default(List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemAdditionalParameter>), List<ComGkSoftwarePosApiModelDomAppServicesTransactionExternalRetailPriceModifier> retailPriceModifierList = default(List<ComGkSoftwarePosApiModelDomAppServicesTransactionExternalRetailPriceModifier>), List<ComGkSoftwarePosApiModelDomAppServicesTransactionLineItemExtension> lineItemExtensionList = default(List<ComGkSoftwarePosApiModelDomAppServicesTransactionLineItemExtension>), List<ComGkSoftwarePosApiModelDomAppServicesTransactionPrintAdditionalLineItemTextLine> printAdditionalLineItemTextLineList = default(List<ComGkSoftwarePosApiModelDomAppServicesTransactionPrintAdditionalLineItemTextLine>))
        {
            // to ensure "actualUnitPrice" is required (not null)
            if (actualUnitPrice == null)
            {
                throw new InvalidDataException("actualUnitPrice is a required property for ComGkSoftwarePosApiServiceTransactionExternalLineItemData and cannot be null");
            }
            else
            {
                this.ActualUnitPrice = actualUnitPrice;
            }
            // to ensure "quantity" is required (not null)
            if (quantity == null)
            {
                throw new InvalidDataException("quantity is a required property for ComGkSoftwarePosApiServiceTransactionExternalLineItemData and cannot be null");
            }
            else
            {
                this.Quantity = quantity;
            }
            // to ensure "receiptText" is required (not null)
            if (receiptText == null)
            {
                throw new InvalidDataException("receiptText is a required property for ComGkSoftwarePosApiServiceTransactionExternalLineItemData and cannot be null");
            }
            else
            {
                this.ReceiptText = receiptText;
            }
            this.PosItemID = posItemID;
            this.ItemID = itemID;
            this.PosDepartmentID = posDepartmentID;
            this.UnitOfMeasureCode = unitOfMeasureCode;
            this.ItemType = itemType;
            this.RegularUnitPrice = regularUnitPrice;
            this.RegularUnitPriceQuantity = regularUnitPriceQuantity;
            this.ActualUnitPriceQuantity = actualUnitPriceQuantity;
            this.Units = units;
            this.QuantityInputMethod = quantityInputMethod;
            this.Length = length;
            this.Width = width;
            this.Height = height;
            this.ReceiptDescription = receiptDescription;
            this.WicFlag = wicFlag;
            this.AllowFoodStampFlag = allowFoodStampFlag;
            this.RegistrationNumber = registrationNumber;
            this.DiscountFlag = discountFlag;
            this.FrequentShopperPointsEligibilityFlag = frequentShopperPointsEligibilityFlag;
            this.DiscountTypeCode = discountTypeCode;
            this.PriceChangeTypeCode = priceChangeTypeCode;
            this.PriceTypeCode = priceTypeCode;
            this.NotConsideredByLoyaltyEngineFlag = notConsideredByLoyaltyEngineFlag;
            this.MerchandiseHierarchyGroupName = merchandiseHierarchyGroupName;
            this.MerchandiseHierarchyGroupDescription = merchandiseHierarchyGroupDescription;
            this.ItemClassCode = itemClassCode;
            this.ProhibitTaxExemptFlag = prohibitTaxExemptFlag;
            this.ProhibitReturnFlag = prohibitReturnFlag;
            this.WarrantyDuration = warrantyDuration;
            this.DepositTypeCode = depositTypeCode;
            this.TaxExemptCode = taxExemptCode;
            this.MainPOSItemID = mainPOSItemID;
            this.MainMerchandiseHierarchyGroupIDQualifier = mainMerchandiseHierarchyGroupIDQualifier;
            this.MainMerchandiseHierarchyGroupID = mainMerchandiseHierarchyGroupID;
            this.TaxGroupID = taxGroupID;
            this.TareCount = tareCount;
            this.SaleReturnLineItemCharacteristicList = saleReturnLineItemCharacteristicList;
            this.SaleReturnLineItemMerchandiseHierarchyGroupList = saleReturnLineItemMerchandiseHierarchyGroupList;
            this.RetailTransactionLineItemI18NTextList = retailTransactionLineItemI18NTextList;
            this.SerializedUnitModifer = serializedUnitModifer;
            this.SaleReturnLineItemSalesOrder = saleReturnLineItemSalesOrder;
            this.ReasonCode = reasonCode;
            this.ReasonCodeGroupCode = reasonCodeGroupCode;
            this.ReasonDescription = reasonDescription;
            this.RetailTransactionLineItemAdditionalParameterList = retailTransactionLineItemAdditionalParameterList;
            this.RetailPriceModifierList = retailPriceModifierList;
            this.LineItemExtensionList = lineItemExtensionList;
            this.PrintAdditionalLineItemTextLineList = printAdditionalLineItemTextLineList;
        }
        
        /// <summary>
        /// &lt;p&gt;The pos item ID - IdentityAlphaNumeric40.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The pos item ID - IdentityAlphaNumeric40.&lt;/p&gt;</value>
        [DataMember(Name="posItemID", EmitDefaultValue=false)]
        public string PosItemID { get; set; }

        /// <summary>
        /// &lt;p&gt;The item ID - IdentityUUID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item ID - IdentityUUID.&lt;/p&gt;</value>
        [DataMember(Name="itemID", EmitDefaultValue=false)]
        public string ItemID { get; set; }

        /// <summary>
        /// &lt;p&gt;The pos department ID - IdentityAlphaNumeric40.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The pos department ID - IdentityAlphaNumeric40.&lt;/p&gt;</value>
        [DataMember(Name="posDepartmentID", EmitDefaultValue=false)]
        public string PosDepartmentID { get; set; }

        /// <summary>
        /// &lt;p&gt;The unit of measure code - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unit of measure code - Code4&lt;/p&gt;</value>
        [DataMember(Name="unitOfMeasureCode", EmitDefaultValue=false)]
        public string UnitOfMeasureCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The item type - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item type - Code4&lt;/p&gt;</value>
        [DataMember(Name="itemType", EmitDefaultValue=false)]
        public string ItemType { get; set; }

        /// <summary>
        /// &lt;p&gt;The regular unit price - MoneyShortRetail&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The regular unit price - MoneyShortRetail&lt;/p&gt;</value>
        [DataMember(Name="regularUnitPrice", EmitDefaultValue=false)]
        public double? RegularUnitPrice { get; set; }

        /// <summary>
        /// &lt;p&gt;The number of items the regular price is defined for, i.e. 3 for $1.00&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of items the regular price is defined for, i.e. 3 for $1.00&lt;/p&gt;</value>
        [DataMember(Name="regularUnitPriceQuantity", EmitDefaultValue=false)]
        public int? RegularUnitPriceQuantity { get; set; }

        /// <summary>
        /// &lt;p&gt;The actual unit price - MoneyShortRetail&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The actual unit price - MoneyShortRetail&lt;/p&gt;</value>
        [DataMember(Name="actualUnitPrice", EmitDefaultValue=false)]
        public double? ActualUnitPrice { get; set; }

        /// <summary>
        /// &lt;p&gt;The number of items the actual price is defined for, i.e. 3 for $1.00&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of items the actual price is defined for, i.e. 3 for $1.00&lt;/p&gt;</value>
        [DataMember(Name="actualUnitPriceQuantity", EmitDefaultValue=false)]
        public int? ActualUnitPriceQuantity { get; set; }

        /// <summary>
        /// &lt;p&gt;The quantity - QuantityIntegerGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity - QuantityIntegerGK&lt;/p&gt;</value>
        [DataMember(Name="quantity", EmitDefaultValue=false)]
        public int? Quantity { get; set; }

        /// <summary>
        /// &lt;p&gt;The units - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The units - Quantity&lt;/p&gt;</value>
        [DataMember(Name="units", EmitDefaultValue=false)]
        public double? Units { get; set; }

        /// <summary>
        /// &lt;p&gt;The quantity input method - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity input method - Code2&lt;/p&gt;</value>
        [DataMember(Name="quantityInputMethod", EmitDefaultValue=false)]
        public string QuantityInputMethod { get; set; }

        /// <summary>
        /// &lt;p&gt;The length - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The length - Quantity&lt;/p&gt;</value>
        [DataMember(Name="length", EmitDefaultValue=false)]
        public double? Length { get; set; }

        /// <summary>
        /// &lt;p&gt;The width - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The width - Quantity&lt;/p&gt;</value>
        [DataMember(Name="width", EmitDefaultValue=false)]
        public double? Width { get; set; }

        /// <summary>
        /// &lt;p&gt;The height - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The height - Quantity&lt;/p&gt;</value>
        [DataMember(Name="height", EmitDefaultValue=false)]
        public double? Height { get; set; }

        /// <summary>
        /// &lt;p&gt;The receipt text - NNameGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The receipt text - NNameGK&lt;/p&gt;</value>
        [DataMember(Name="receiptText", EmitDefaultValue=false)]
        public string ReceiptText { get; set; }

        /// <summary>
        /// &lt;p&gt;The receipt description - NDescriptionShortGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The receipt description - NDescriptionShortGK&lt;/p&gt;</value>
        [DataMember(Name="receiptDescription", EmitDefaultValue=false)]
        public string ReceiptDescription { get; set; }

        /// <summary>
        /// &lt;p&gt;The wic flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The wic flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="wicFlag", EmitDefaultValue=false)]
        public bool? WicFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The allow food stamp flag -&amp;gt; BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The allow food stamp flag -&amp;gt; BIT&lt;/p&gt;</value>
        [DataMember(Name="allowFoodStampFlag", EmitDefaultValue=false)]
        public bool? AllowFoodStampFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The registration number - DescriptionShort&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The registration number - DescriptionShort&lt;/p&gt;</value>
        [DataMember(Name="registrationNumber", EmitDefaultValue=false)]
        public string RegistrationNumber { get; set; }

        /// <summary>
        /// &lt;p&gt;The discount flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The discount flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="discountFlag", EmitDefaultValue=false)]
        public bool? DiscountFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The frequent shopper points eligibility flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The frequent shopper points eligibility flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="frequentShopperPointsEligibilityFlag", EmitDefaultValue=false)]
        public bool? FrequentShopperPointsEligibilityFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The discount type code - VARCHAR(1)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The discount type code - VARCHAR(1)&lt;/p&gt;</value>
        [DataMember(Name="discountTypeCode", EmitDefaultValue=false)]
        public string DiscountTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The price change type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The price change type code - Code2&lt;/p&gt;</value>
        [DataMember(Name="priceChangeTypeCode", EmitDefaultValue=false)]
        public string PriceChangeTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The price type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The price type code - Code2&lt;/p&gt;</value>
        [DataMember(Name="priceTypeCode", EmitDefaultValue=false)]
        public string PriceTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The not considered by loyalty engine flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The not considered by loyalty engine flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="notConsideredByLoyaltyEngineFlag", EmitDefaultValue=false)]
        public bool? NotConsideredByLoyaltyEngineFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The merchandise hierarchy group name - Name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The merchandise hierarchy group name - Name&lt;/p&gt;</value>
        [DataMember(Name="merchandiseHierarchyGroupName", EmitDefaultValue=false)]
        public string MerchandiseHierarchyGroupName { get; set; }

        /// <summary>
        /// &lt;p&gt;The merchandise hierarchy group description - DescriptionShort&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The merchandise hierarchy group description - DescriptionShort&lt;/p&gt;</value>
        [DataMember(Name="merchandiseHierarchyGroupDescription", EmitDefaultValue=false)]
        public string MerchandiseHierarchyGroupDescription { get; set; }

        /// <summary>
        /// &lt;p&gt;The PosUOMItemDO class code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The PosUOMItemDO class code.&lt;/p&gt;</value>
        [DataMember(Name="itemClassCode", EmitDefaultValue=false)]
        public string ItemClassCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The prohibit tax exempt flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The prohibit tax exempt flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="prohibitTaxExemptFlag", EmitDefaultValue=false)]
        public bool? ProhibitTaxExemptFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The prohibit return flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The prohibit return flag - BIT&lt;/p&gt;</value>
        [DataMember(Name="prohibitReturnFlag", EmitDefaultValue=false)]
        public bool? ProhibitReturnFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The warranty duration - QuantityTransactionCount&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The warranty duration - QuantityTransactionCount&lt;/p&gt;</value>
        [DataMember(Name="warrantyDuration", EmitDefaultValue=false)]
        public double? WarrantyDuration { get; set; }

        /// <summary>
        /// &lt;p&gt;The deposit type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The deposit type code - Code2&lt;/p&gt;</value>
        [DataMember(Name="depositTypeCode", EmitDefaultValue=false)]
        public string DepositTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The tax exempt code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tax exempt code - Code2&lt;/p&gt;</value>
        [DataMember(Name="taxExemptCode", EmitDefaultValue=false)]
        public string TaxExemptCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The main POS item ID - IdentityGTIN&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main POS item ID - IdentityGTIN&lt;/p&gt;</value>
        [DataMember(Name="mainPOSItemID", EmitDefaultValue=false)]
        public string MainPOSItemID { get; set; }

        /// <summary>
        /// &lt;p&gt;The main merchandise hierarchy group ID qualifier - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main merchandise hierarchy group ID qualifier - Code4&lt;/p&gt;</value>
        [DataMember(Name="mainMerchandiseHierarchyGroupIDQualifier", EmitDefaultValue=false)]
        public string MainMerchandiseHierarchyGroupIDQualifier { get; set; }

        /// <summary>
        /// &lt;p&gt;The main merchandise hierarchy group ID - IdentityAlphaNumeric40&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main merchandise hierarchy group ID - IdentityAlphaNumeric40&lt;/p&gt;</value>
        [DataMember(Name="mainMerchandiseHierarchyGroupID", EmitDefaultValue=false)]
        public string MainMerchandiseHierarchyGroupID { get; set; }

        /// <summary>
        /// &lt;p&gt;The tax group ID - Code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tax group ID - Code&lt;/p&gt;</value>
        [DataMember(Name="taxGroupID", EmitDefaultValue=false)]
        public string TaxGroupID { get; set; }

        /// <summary>
        /// &lt;p&gt;The tare ount - Quantity16_3GK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tare ount - Quantity16_3GK&lt;/p&gt;</value>
        [DataMember(Name="tareCount", EmitDefaultValue=false)]
        public double? TareCount { get; set; }

        /// <summary>
        /// &lt;p&gt;The sale return line item characteristic list - SaleReturnLineItemCharacteristic[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item characteristic list - SaleReturnLineItemCharacteristic[0..*]&lt;/p&gt;</value>
        [DataMember(Name="saleReturnLineItemCharacteristicList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemCharacteristic> SaleReturnLineItemCharacteristicList { get; set; }

        /// <summary>
        /// &lt;p&gt;The sale return line item merchandise hierarchy group list - SaleReturnLineItemMerchandiseHierarchyGroup[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item merchandise hierarchy group list - SaleReturnLineItemMerchandiseHierarchyGroup[0..*]&lt;/p&gt;</value>
        [DataMember(Name="saleReturnLineItemMerchandiseHierarchyGroupList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemMerchandiseHierarchyGroup> SaleReturnLineItemMerchandiseHierarchyGroupList { get; set; }

        /// <summary>
        /// &lt;p&gt;The retail transaction line item I18N text list - RetailTransactionLineItemI18NText[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail transaction line item I18N text list - RetailTransactionLineItemI18NText[0..*]&lt;/p&gt;</value>
        [DataMember(Name="retailTransactionLineItemI18NTextList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemI18NText> RetailTransactionLineItemI18NTextList { get; set; }

        /// <summary>
        /// &lt;p&gt;The serialized unit modifer - SerializedUnitModifer&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The serialized unit modifer - SerializedUnitModifer&lt;/p&gt;</value>
        [DataMember(Name="serializedUnitModifer", EmitDefaultValue=false)]
        public ComGkSoftwarePosApiServiceTransactionSerializedUnitModifer SerializedUnitModifer { get; set; }

        /// <summary>
        /// &lt;p&gt;The sale return line item sales order - SaleReturnLineItemSalesOrder&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item sales order - SaleReturnLineItemSalesOrder&lt;/p&gt;</value>
        [DataMember(Name="saleReturnLineItemSalesOrder", EmitDefaultValue=false)]
        public ComGkSoftwarePosApiServiceTransactionSaleReturnLineItemSalesOrder SaleReturnLineItemSalesOrder { get; set; }

        /// <summary>
        /// &lt;p&gt;The reason code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason code&lt;/p&gt;</value>
        [DataMember(Name="reasonCode", EmitDefaultValue=false)]
        public string ReasonCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The reason code group code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason code group code&lt;/p&gt;</value>
        [DataMember(Name="reasonCodeGroupCode", EmitDefaultValue=false)]
        public string ReasonCodeGroupCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The reason description&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason description&lt;/p&gt;</value>
        [DataMember(Name="reasonDescription", EmitDefaultValue=false)]
        public string ReasonDescription { get; set; }

        /// <summary>
        /// &lt;p&gt;The retail transaction line item additional parameter list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail transaction line item additional parameter list&lt;/p&gt;</value>
        [DataMember(Name="retailTransactionLineItemAdditionalParameterList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiServiceTransactionRetailTransactionLineItemAdditionalParameter> RetailTransactionLineItemAdditionalParameterList { get; set; }

        /// <summary>
        /// &lt;p&gt;The retail price modifier list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail price modifier list&lt;/p&gt;</value>
        [DataMember(Name="retailPriceModifierList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiModelDomAppServicesTransactionExternalRetailPriceModifier> RetailPriceModifierList { get; set; }

        /// <summary>
        /// &lt;p&gt;The line item extension list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The line item extension list&lt;/p&gt;</value>
        [DataMember(Name="lineItemExtensionList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiModelDomAppServicesTransactionLineItemExtension> LineItemExtensionList { get; set; }

        /// <summary>
        /// &lt;p&gt;The print additional line item text line list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The print additional line item text line list&lt;/p&gt;</value>
        [DataMember(Name="printAdditionalLineItemTextLineList", EmitDefaultValue=false)]
        public List<ComGkSoftwarePosApiModelDomAppServicesTransactionPrintAdditionalLineItemTextLine> PrintAdditionalLineItemTextLineList { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ComGkSoftwarePosApiServiceTransactionExternalLineItemData {\n");
            sb.Append("  PosItemID: ").Append(PosItemID).Append("\n");
            sb.Append("  ItemID: ").Append(ItemID).Append("\n");
            sb.Append("  PosDepartmentID: ").Append(PosDepartmentID).Append("\n");
            sb.Append("  UnitOfMeasureCode: ").Append(UnitOfMeasureCode).Append("\n");
            sb.Append("  ItemType: ").Append(ItemType).Append("\n");
            sb.Append("  RegularUnitPrice: ").Append(RegularUnitPrice).Append("\n");
            sb.Append("  RegularUnitPriceQuantity: ").Append(RegularUnitPriceQuantity).Append("\n");
            sb.Append("  ActualUnitPrice: ").Append(ActualUnitPrice).Append("\n");
            sb.Append("  ActualUnitPriceQuantity: ").Append(ActualUnitPriceQuantity).Append("\n");
            sb.Append("  Quantity: ").Append(Quantity).Append("\n");
            sb.Append("  Units: ").Append(Units).Append("\n");
            sb.Append("  QuantityInputMethod: ").Append(QuantityInputMethod).Append("\n");
            sb.Append("  Length: ").Append(Length).Append("\n");
            sb.Append("  Width: ").Append(Width).Append("\n");
            sb.Append("  Height: ").Append(Height).Append("\n");
            sb.Append("  ReceiptText: ").Append(ReceiptText).Append("\n");
            sb.Append("  ReceiptDescription: ").Append(ReceiptDescription).Append("\n");
            sb.Append("  WicFlag: ").Append(WicFlag).Append("\n");
            sb.Append("  AllowFoodStampFlag: ").Append(AllowFoodStampFlag).Append("\n");
            sb.Append("  RegistrationNumber: ").Append(RegistrationNumber).Append("\n");
            sb.Append("  DiscountFlag: ").Append(DiscountFlag).Append("\n");
            sb.Append("  FrequentShopperPointsEligibilityFlag: ").Append(FrequentShopperPointsEligibilityFlag).Append("\n");
            sb.Append("  DiscountTypeCode: ").Append(DiscountTypeCode).Append("\n");
            sb.Append("  PriceChangeTypeCode: ").Append(PriceChangeTypeCode).Append("\n");
            sb.Append("  PriceTypeCode: ").Append(PriceTypeCode).Append("\n");
            sb.Append("  NotConsideredByLoyaltyEngineFlag: ").Append(NotConsideredByLoyaltyEngineFlag).Append("\n");
            sb.Append("  MerchandiseHierarchyGroupName: ").Append(MerchandiseHierarchyGroupName).Append("\n");
            sb.Append("  MerchandiseHierarchyGroupDescription: ").Append(MerchandiseHierarchyGroupDescription).Append("\n");
            sb.Append("  ItemClassCode: ").Append(ItemClassCode).Append("\n");
            sb.Append("  ProhibitTaxExemptFlag: ").Append(ProhibitTaxExemptFlag).Append("\n");
            sb.Append("  ProhibitReturnFlag: ").Append(ProhibitReturnFlag).Append("\n");
            sb.Append("  WarrantyDuration: ").Append(WarrantyDuration).Append("\n");
            sb.Append("  DepositTypeCode: ").Append(DepositTypeCode).Append("\n");
            sb.Append("  TaxExemptCode: ").Append(TaxExemptCode).Append("\n");
            sb.Append("  MainPOSItemID: ").Append(MainPOSItemID).Append("\n");
            sb.Append("  MainMerchandiseHierarchyGroupIDQualifier: ").Append(MainMerchandiseHierarchyGroupIDQualifier).Append("\n");
            sb.Append("  MainMerchandiseHierarchyGroupID: ").Append(MainMerchandiseHierarchyGroupID).Append("\n");
            sb.Append("  TaxGroupID: ").Append(TaxGroupID).Append("\n");
            sb.Append("  TareCount: ").Append(TareCount).Append("\n");
            sb.Append("  SaleReturnLineItemCharacteristicList: ").Append(SaleReturnLineItemCharacteristicList).Append("\n");
            sb.Append("  SaleReturnLineItemMerchandiseHierarchyGroupList: ").Append(SaleReturnLineItemMerchandiseHierarchyGroupList).Append("\n");
            sb.Append("  RetailTransactionLineItemI18NTextList: ").Append(RetailTransactionLineItemI18NTextList).Append("\n");
            sb.Append("  SerializedUnitModifer: ").Append(SerializedUnitModifer).Append("\n");
            sb.Append("  SaleReturnLineItemSalesOrder: ").Append(SaleReturnLineItemSalesOrder).Append("\n");
            sb.Append("  ReasonCode: ").Append(ReasonCode).Append("\n");
            sb.Append("  ReasonCodeGroupCode: ").Append(ReasonCodeGroupCode).Append("\n");
            sb.Append("  ReasonDescription: ").Append(ReasonDescription).Append("\n");
            sb.Append("  RetailTransactionLineItemAdditionalParameterList: ").Append(RetailTransactionLineItemAdditionalParameterList).Append("\n");
            sb.Append("  RetailPriceModifierList: ").Append(RetailPriceModifierList).Append("\n");
            sb.Append("  LineItemExtensionList: ").Append(LineItemExtensionList).Append("\n");
            sb.Append("  PrintAdditionalLineItemTextLineList: ").Append(PrintAdditionalLineItemTextLineList).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ComGkSoftwarePosApiServiceTransactionExternalLineItemData);
        }

        /// <summary>
        /// Returns true if ComGkSoftwarePosApiServiceTransactionExternalLineItemData instances are equal
        /// </summary>
        /// <param name="input">Instance of ComGkSoftwarePosApiServiceTransactionExternalLineItemData to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ComGkSoftwarePosApiServiceTransactionExternalLineItemData input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.PosItemID == input.PosItemID ||
                    (this.PosItemID != null &&
                    this.PosItemID.Equals(input.PosItemID))
                ) && 
                (
                    this.ItemID == input.ItemID ||
                    (this.ItemID != null &&
                    this.ItemID.Equals(input.ItemID))
                ) && 
                (
                    this.PosDepartmentID == input.PosDepartmentID ||
                    (this.PosDepartmentID != null &&
                    this.PosDepartmentID.Equals(input.PosDepartmentID))
                ) && 
                (
                    this.UnitOfMeasureCode == input.UnitOfMeasureCode ||
                    (this.UnitOfMeasureCode != null &&
                    this.UnitOfMeasureCode.Equals(input.UnitOfMeasureCode))
                ) && 
                (
                    this.ItemType == input.ItemType ||
                    (this.ItemType != null &&
                    this.ItemType.Equals(input.ItemType))
                ) && 
                (
                    this.RegularUnitPrice == input.RegularUnitPrice ||
                    (this.RegularUnitPrice != null &&
                    this.RegularUnitPrice.Equals(input.RegularUnitPrice))
                ) && 
                (
                    this.RegularUnitPriceQuantity == input.RegularUnitPriceQuantity ||
                    (this.RegularUnitPriceQuantity != null &&
                    this.RegularUnitPriceQuantity.Equals(input.RegularUnitPriceQuantity))
                ) && 
                (
                    this.ActualUnitPrice == input.ActualUnitPrice ||
                    (this.ActualUnitPrice != null &&
                    this.ActualUnitPrice.Equals(input.ActualUnitPrice))
                ) && 
                (
                    this.ActualUnitPriceQuantity == input.ActualUnitPriceQuantity ||
                    (this.ActualUnitPriceQuantity != null &&
                    this.ActualUnitPriceQuantity.Equals(input.ActualUnitPriceQuantity))
                ) && 
                (
                    this.Quantity == input.Quantity ||
                    (this.Quantity != null &&
                    this.Quantity.Equals(input.Quantity))
                ) && 
                (
                    this.Units == input.Units ||
                    (this.Units != null &&
                    this.Units.Equals(input.Units))
                ) && 
                (
                    this.QuantityInputMethod == input.QuantityInputMethod ||
                    (this.QuantityInputMethod != null &&
                    this.QuantityInputMethod.Equals(input.QuantityInputMethod))
                ) && 
                (
                    this.Length == input.Length ||
                    (this.Length != null &&
                    this.Length.Equals(input.Length))
                ) && 
                (
                    this.Width == input.Width ||
                    (this.Width != null &&
                    this.Width.Equals(input.Width))
                ) && 
                (
                    this.Height == input.Height ||
                    (this.Height != null &&
                    this.Height.Equals(input.Height))
                ) && 
                (
                    this.ReceiptText == input.ReceiptText ||
                    (this.ReceiptText != null &&
                    this.ReceiptText.Equals(input.ReceiptText))
                ) && 
                (
                    this.ReceiptDescription == input.ReceiptDescription ||
                    (this.ReceiptDescription != null &&
                    this.ReceiptDescription.Equals(input.ReceiptDescription))
                ) && 
                (
                    this.WicFlag == input.WicFlag ||
                    (this.WicFlag != null &&
                    this.WicFlag.Equals(input.WicFlag))
                ) && 
                (
                    this.AllowFoodStampFlag == input.AllowFoodStampFlag ||
                    (this.AllowFoodStampFlag != null &&
                    this.AllowFoodStampFlag.Equals(input.AllowFoodStampFlag))
                ) && 
                (
                    this.RegistrationNumber == input.RegistrationNumber ||
                    (this.RegistrationNumber != null &&
                    this.RegistrationNumber.Equals(input.RegistrationNumber))
                ) && 
                (
                    this.DiscountFlag == input.DiscountFlag ||
                    (this.DiscountFlag != null &&
                    this.DiscountFlag.Equals(input.DiscountFlag))
                ) && 
                (
                    this.FrequentShopperPointsEligibilityFlag == input.FrequentShopperPointsEligibilityFlag ||
                    (this.FrequentShopperPointsEligibilityFlag != null &&
                    this.FrequentShopperPointsEligibilityFlag.Equals(input.FrequentShopperPointsEligibilityFlag))
                ) && 
                (
                    this.DiscountTypeCode == input.DiscountTypeCode ||
                    (this.DiscountTypeCode != null &&
                    this.DiscountTypeCode.Equals(input.DiscountTypeCode))
                ) && 
                (
                    this.PriceChangeTypeCode == input.PriceChangeTypeCode ||
                    (this.PriceChangeTypeCode != null &&
                    this.PriceChangeTypeCode.Equals(input.PriceChangeTypeCode))
                ) && 
                (
                    this.PriceTypeCode == input.PriceTypeCode ||
                    (this.PriceTypeCode != null &&
                    this.PriceTypeCode.Equals(input.PriceTypeCode))
                ) && 
                (
                    this.NotConsideredByLoyaltyEngineFlag == input.NotConsideredByLoyaltyEngineFlag ||
                    (this.NotConsideredByLoyaltyEngineFlag != null &&
                    this.NotConsideredByLoyaltyEngineFlag.Equals(input.NotConsideredByLoyaltyEngineFlag))
                ) && 
                (
                    this.MerchandiseHierarchyGroupName == input.MerchandiseHierarchyGroupName ||
                    (this.MerchandiseHierarchyGroupName != null &&
                    this.MerchandiseHierarchyGroupName.Equals(input.MerchandiseHierarchyGroupName))
                ) && 
                (
                    this.MerchandiseHierarchyGroupDescription == input.MerchandiseHierarchyGroupDescription ||
                    (this.MerchandiseHierarchyGroupDescription != null &&
                    this.MerchandiseHierarchyGroupDescription.Equals(input.MerchandiseHierarchyGroupDescription))
                ) && 
                (
                    this.ItemClassCode == input.ItemClassCode ||
                    (this.ItemClassCode != null &&
                    this.ItemClassCode.Equals(input.ItemClassCode))
                ) && 
                (
                    this.ProhibitTaxExemptFlag == input.ProhibitTaxExemptFlag ||
                    (this.ProhibitTaxExemptFlag != null &&
                    this.ProhibitTaxExemptFlag.Equals(input.ProhibitTaxExemptFlag))
                ) && 
                (
                    this.ProhibitReturnFlag == input.ProhibitReturnFlag ||
                    (this.ProhibitReturnFlag != null &&
                    this.ProhibitReturnFlag.Equals(input.ProhibitReturnFlag))
                ) && 
                (
                    this.WarrantyDuration == input.WarrantyDuration ||
                    (this.WarrantyDuration != null &&
                    this.WarrantyDuration.Equals(input.WarrantyDuration))
                ) && 
                (
                    this.DepositTypeCode == input.DepositTypeCode ||
                    (this.DepositTypeCode != null &&
                    this.DepositTypeCode.Equals(input.DepositTypeCode))
                ) && 
                (
                    this.TaxExemptCode == input.TaxExemptCode ||
                    (this.TaxExemptCode != null &&
                    this.TaxExemptCode.Equals(input.TaxExemptCode))
                ) && 
                (
                    this.MainPOSItemID == input.MainPOSItemID ||
                    (this.MainPOSItemID != null &&
                    this.MainPOSItemID.Equals(input.MainPOSItemID))
                ) && 
                (
                    this.MainMerchandiseHierarchyGroupIDQualifier == input.MainMerchandiseHierarchyGroupIDQualifier ||
                    (this.MainMerchandiseHierarchyGroupIDQualifier != null &&
                    this.MainMerchandiseHierarchyGroupIDQualifier.Equals(input.MainMerchandiseHierarchyGroupIDQualifier))
                ) && 
                (
                    this.MainMerchandiseHierarchyGroupID == input.MainMerchandiseHierarchyGroupID ||
                    (this.MainMerchandiseHierarchyGroupID != null &&
                    this.MainMerchandiseHierarchyGroupID.Equals(input.MainMerchandiseHierarchyGroupID))
                ) && 
                (
                    this.TaxGroupID == input.TaxGroupID ||
                    (this.TaxGroupID != null &&
                    this.TaxGroupID.Equals(input.TaxGroupID))
                ) && 
                (
                    this.TareCount == input.TareCount ||
                    (this.TareCount != null &&
                    this.TareCount.Equals(input.TareCount))
                ) && 
                (
                    this.SaleReturnLineItemCharacteristicList == input.SaleReturnLineItemCharacteristicList ||
                    this.SaleReturnLineItemCharacteristicList != null &&
                    this.SaleReturnLineItemCharacteristicList.SequenceEqual(input.SaleReturnLineItemCharacteristicList)
                ) && 
                (
                    this.SaleReturnLineItemMerchandiseHierarchyGroupList == input.SaleReturnLineItemMerchandiseHierarchyGroupList ||
                    this.SaleReturnLineItemMerchandiseHierarchyGroupList != null &&
                    this.SaleReturnLineItemMerchandiseHierarchyGroupList.SequenceEqual(input.SaleReturnLineItemMerchandiseHierarchyGroupList)
                ) && 
                (
                    this.RetailTransactionLineItemI18NTextList == input.RetailTransactionLineItemI18NTextList ||
                    this.RetailTransactionLineItemI18NTextList != null &&
                    this.RetailTransactionLineItemI18NTextList.SequenceEqual(input.RetailTransactionLineItemI18NTextList)
                ) && 
                (
                    this.SerializedUnitModifer == input.SerializedUnitModifer ||
                    (this.SerializedUnitModifer != null &&
                    this.SerializedUnitModifer.Equals(input.SerializedUnitModifer))
                ) && 
                (
                    this.SaleReturnLineItemSalesOrder == input.SaleReturnLineItemSalesOrder ||
                    (this.SaleReturnLineItemSalesOrder != null &&
                    this.SaleReturnLineItemSalesOrder.Equals(input.SaleReturnLineItemSalesOrder))
                ) && 
                (
                    this.ReasonCode == input.ReasonCode ||
                    (this.ReasonCode != null &&
                    this.ReasonCode.Equals(input.ReasonCode))
                ) && 
                (
                    this.ReasonCodeGroupCode == input.ReasonCodeGroupCode ||
                    (this.ReasonCodeGroupCode != null &&
                    this.ReasonCodeGroupCode.Equals(input.ReasonCodeGroupCode))
                ) && 
                (
                    this.ReasonDescription == input.ReasonDescription ||
                    (this.ReasonDescription != null &&
                    this.ReasonDescription.Equals(input.ReasonDescription))
                ) && 
                (
                    this.RetailTransactionLineItemAdditionalParameterList == input.RetailTransactionLineItemAdditionalParameterList ||
                    this.RetailTransactionLineItemAdditionalParameterList != null &&
                    this.RetailTransactionLineItemAdditionalParameterList.SequenceEqual(input.RetailTransactionLineItemAdditionalParameterList)
                ) && 
                (
                    this.RetailPriceModifierList == input.RetailPriceModifierList ||
                    this.RetailPriceModifierList != null &&
                    this.RetailPriceModifierList.SequenceEqual(input.RetailPriceModifierList)
                ) && 
                (
                    this.LineItemExtensionList == input.LineItemExtensionList ||
                    this.LineItemExtensionList != null &&
                    this.LineItemExtensionList.SequenceEqual(input.LineItemExtensionList)
                ) && 
                (
                    this.PrintAdditionalLineItemTextLineList == input.PrintAdditionalLineItemTextLineList ||
                    this.PrintAdditionalLineItemTextLineList != null &&
                    this.PrintAdditionalLineItemTextLineList.SequenceEqual(input.PrintAdditionalLineItemTextLineList)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.PosItemID != null)
                    hashCode = hashCode * 59 + this.PosItemID.GetHashCode();
                if (this.ItemID != null)
                    hashCode = hashCode * 59 + this.ItemID.GetHashCode();
                if (this.PosDepartmentID != null)
                    hashCode = hashCode * 59 + this.PosDepartmentID.GetHashCode();
                if (this.UnitOfMeasureCode != null)
                    hashCode = hashCode * 59 + this.UnitOfMeasureCode.GetHashCode();
                if (this.ItemType != null)
                    hashCode = hashCode * 59 + this.ItemType.GetHashCode();
                if (this.RegularUnitPrice != null)
                    hashCode = hashCode * 59 + this.RegularUnitPrice.GetHashCode();
                if (this.RegularUnitPriceQuantity != null)
                    hashCode = hashCode * 59 + this.RegularUnitPriceQuantity.GetHashCode();
                if (this.ActualUnitPrice != null)
                    hashCode = hashCode * 59 + this.ActualUnitPrice.GetHashCode();
                if (this.ActualUnitPriceQuantity != null)
                    hashCode = hashCode * 59 + this.ActualUnitPriceQuantity.GetHashCode();
                if (this.Quantity != null)
                    hashCode = hashCode * 59 + this.Quantity.GetHashCode();
                if (this.Units != null)
                    hashCode = hashCode * 59 + this.Units.GetHashCode();
                if (this.QuantityInputMethod != null)
                    hashCode = hashCode * 59 + this.QuantityInputMethod.GetHashCode();
                if (this.Length != null)
                    hashCode = hashCode * 59 + this.Length.GetHashCode();
                if (this.Width != null)
                    hashCode = hashCode * 59 + this.Width.GetHashCode();
                if (this.Height != null)
                    hashCode = hashCode * 59 + this.Height.GetHashCode();
                if (this.ReceiptText != null)
                    hashCode = hashCode * 59 + this.ReceiptText.GetHashCode();
                if (this.ReceiptDescription != null)
                    hashCode = hashCode * 59 + this.ReceiptDescription.GetHashCode();
                if (this.WicFlag != null)
                    hashCode = hashCode * 59 + this.WicFlag.GetHashCode();
                if (this.AllowFoodStampFlag != null)
                    hashCode = hashCode * 59 + this.AllowFoodStampFlag.GetHashCode();
                if (this.RegistrationNumber != null)
                    hashCode = hashCode * 59 + this.RegistrationNumber.GetHashCode();
                if (this.DiscountFlag != null)
                    hashCode = hashCode * 59 + this.DiscountFlag.GetHashCode();
                if (this.FrequentShopperPointsEligibilityFlag != null)
                    hashCode = hashCode * 59 + this.FrequentShopperPointsEligibilityFlag.GetHashCode();
                if (this.DiscountTypeCode != null)
                    hashCode = hashCode * 59 + this.DiscountTypeCode.GetHashCode();
                if (this.PriceChangeTypeCode != null)
                    hashCode = hashCode * 59 + this.PriceChangeTypeCode.GetHashCode();
                if (this.PriceTypeCode != null)
                    hashCode = hashCode * 59 + this.PriceTypeCode.GetHashCode();
                if (this.NotConsideredByLoyaltyEngineFlag != null)
                    hashCode = hashCode * 59 + this.NotConsideredByLoyaltyEngineFlag.GetHashCode();
                if (this.MerchandiseHierarchyGroupName != null)
                    hashCode = hashCode * 59 + this.MerchandiseHierarchyGroupName.GetHashCode();
                if (this.MerchandiseHierarchyGroupDescription != null)
                    hashCode = hashCode * 59 + this.MerchandiseHierarchyGroupDescription.GetHashCode();
                if (this.ItemClassCode != null)
                    hashCode = hashCode * 59 + this.ItemClassCode.GetHashCode();
                if (this.ProhibitTaxExemptFlag != null)
                    hashCode = hashCode * 59 + this.ProhibitTaxExemptFlag.GetHashCode();
                if (this.ProhibitReturnFlag != null)
                    hashCode = hashCode * 59 + this.ProhibitReturnFlag.GetHashCode();
                if (this.WarrantyDuration != null)
                    hashCode = hashCode * 59 + this.WarrantyDuration.GetHashCode();
                if (this.DepositTypeCode != null)
                    hashCode = hashCode * 59 + this.DepositTypeCode.GetHashCode();
                if (this.TaxExemptCode != null)
                    hashCode = hashCode * 59 + this.TaxExemptCode.GetHashCode();
                if (this.MainPOSItemID != null)
                    hashCode = hashCode * 59 + this.MainPOSItemID.GetHashCode();
                if (this.MainMerchandiseHierarchyGroupIDQualifier != null)
                    hashCode = hashCode * 59 + this.MainMerchandiseHierarchyGroupIDQualifier.GetHashCode();
                if (this.MainMerchandiseHierarchyGroupID != null)
                    hashCode = hashCode * 59 + this.MainMerchandiseHierarchyGroupID.GetHashCode();
                if (this.TaxGroupID != null)
                    hashCode = hashCode * 59 + this.TaxGroupID.GetHashCode();
                if (this.TareCount != null)
                    hashCode = hashCode * 59 + this.TareCount.GetHashCode();
                if (this.SaleReturnLineItemCharacteristicList != null)
                    hashCode = hashCode * 59 + this.SaleReturnLineItemCharacteristicList.GetHashCode();
                if (this.SaleReturnLineItemMerchandiseHierarchyGroupList != null)
                    hashCode = hashCode * 59 + this.SaleReturnLineItemMerchandiseHierarchyGroupList.GetHashCode();
                if (this.RetailTransactionLineItemI18NTextList != null)
                    hashCode = hashCode * 59 + this.RetailTransactionLineItemI18NTextList.GetHashCode();
                if (this.SerializedUnitModifer != null)
                    hashCode = hashCode * 59 + this.SerializedUnitModifer.GetHashCode();
                if (this.SaleReturnLineItemSalesOrder != null)
                    hashCode = hashCode * 59 + this.SaleReturnLineItemSalesOrder.GetHashCode();
                if (this.ReasonCode != null)
                    hashCode = hashCode * 59 + this.ReasonCode.GetHashCode();
                if (this.ReasonCodeGroupCode != null)
                    hashCode = hashCode * 59 + this.ReasonCodeGroupCode.GetHashCode();
                if (this.ReasonDescription != null)
                    hashCode = hashCode * 59 + this.ReasonDescription.GetHashCode();
                if (this.RetailTransactionLineItemAdditionalParameterList != null)
                    hashCode = hashCode * 59 + this.RetailTransactionLineItemAdditionalParameterList.GetHashCode();
                if (this.RetailPriceModifierList != null)
                    hashCode = hashCode * 59 + this.RetailPriceModifierList.GetHashCode();
                if (this.LineItemExtensionList != null)
                    hashCode = hashCode * 59 + this.LineItemExtensionList.GetHashCode();
                if (this.PrintAdditionalLineItemTextLineList != null)
                    hashCode = hashCode * 59 + this.PrintAdditionalLineItemTextLineList.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
