﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Policy;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de agregar item - (AddItemResponse)
    /// </summary>
    public class AddItemResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string Description { get; set; }
        public string ReturnFlag { get; set; }
        public string DepositFlag { get; set; }
        public string VoidFlag { get; set; }
        public string ItemIdentifier { get; set; }
        public string ItemEntryMethod { get; set; }
        public string RegularUnitPrice { get; set; }
        //Prueba en string, porque en double hay error
        public string ExtendedPrice { get; set; }
        public int Quantity { get; set; }
        public double Weight { get; set; }
        public string DealPrice { get; set; }
        public int DealQuantity { get; set; }
        public int DepartmentNumber { get; set; }
        public int MixAndMatchPricingGroup { get; set; }
        public string PriceDerivationMethod { get; set; }
        public string TimeRestrictedFlag { get; set; }
        public int RestrictedAge { get; set; }
        public string FoodStampEligibleFlag { get; set; }
        public string WICEligibleFlag { get; set; }
        public string ItemRepeatAllowedFlag { get; set; }
        public string TaxableFlag { get; set; }
        private string _xml;

        public AddItemResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string description,
                                 string returnFlag,
                                 string depositFlag,
                                 string voidFlag,
                                 string itemIdentifier,
                                 string itemEntryMethod,
                                 string regularUnitPrice,
                                 int quantity,
                                 string extendedPrice,
                                 double weight,
                                 string dealPrice,
                                 int dealQuantity,
                                 int departmentNumber,
                                 int mixAndMatchPricingGroup,
                                 string priceDerivationMethod,
                                 string timeRestrictedFlag,
                                 int restrictedAge,
                                 string foodStampEligibleFlag,
                                 string wICEligibleFlag,
                                 string itemRepeatAllowedFlag,
                                 string taxableFlag) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Description = description;
            ReturnFlag = returnFlag;
            DepositFlag = depositFlag;
            VoidFlag = voidFlag;
            ItemIdentifier = itemIdentifier;
            ItemEntryMethod = itemEntryMethod;
            RegularUnitPrice = regularUnitPrice;
            Quantity = quantity;
            ExtendedPrice = extendedPrice;
            Weight = weight;
            DealPrice = dealPrice;
            DealQuantity = dealQuantity;
            DepartmentNumber = departmentNumber;
            MixAndMatchPricingGroup = mixAndMatchPricingGroup;
            PriceDerivationMethod = priceDerivationMethod;
            TimeRestrictedFlag = timeRestrictedFlag;
            RestrictedAge = restrictedAge;
            FoodStampEligibleFlag = foodStampEligibleFlag;
            WICEligibleFlag = wICEligibleFlag;
            ItemRepeatAllowedFlag = itemRepeatAllowedFlag;
            TaxableFlag = taxableFlag;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddItemResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                        <AddItemResult>
                          <RequestID>{RequestID}</RequestID>
                          <LineItem>
                            <Description>{Description}</Description>
                            <ReturnFlag>{ReturnFlag}</ReturnFlag>
                            <DepositFlag>{DepositFlag}</DepositFlag>
                            <VoidFlag>{VoidFlag}</VoidFlag>
                            <ItemIdentifier>{ItemIdentifier}</ItemIdentifier>
                            <ItemEntryMethod>{ItemEntryMethod}</ItemEntryMethod>
                            <RegularUnitPrice>{RegularUnitPrice}</RegularUnitPrice>
                            <Quantity>{Quantity}</Quantity>
                            <ExtendedPrice>{ExtendedPrice}</ExtendedPrice>
                            <Weight>{Weight}</Weight>
                            <DealPrice>{DealPrice}</DealPrice>
                            <DealQuantity>{DealQuantity}</DealQuantity>
                            <DepartmentNumber>{DepartmentNumber}</DepartmentNumber>
                            <MixAndMatchPricingGroup>{MixAndMatchPricingGroup}</MixAndMatchPricingGroup>
                            <PriceDerivationMethod>{PriceDerivationMethod}</PriceDerivationMethod>
                            <TimeRestrictedFlag>{TimeRestrictedFlag}</TimeRestrictedFlag>
                            <RestrictedAge>{RestrictedAge}</RestrictedAge>
                            <FoodStampEligibleFlag>{FoodStampEligibleFlag}</FoodStampEligibleFlag>
                            <WICEligibleFlag>{WICEligibleFlag}</WICEligibleFlag>
                            <ItemRepeatAllowedFlag>{ItemRepeatAllowedFlag}</ItemRepeatAllowedFlag>
                            <TaxableFlag>{TaxableFlag}</TaxableFlag>
                          </LineItem>
                        </AddItemResult>
                        </schema:AddItemResponse>
                        """;
        }

    }
}
