﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Ultima respuesta cuando se va a pagar con tarjeta de credito
    /// </summary>
    public class AddTenderDebitResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string ReturnFlag { get; set; }
        public string DepositFlag { get; set; }
        public string VoidFlag { get; set; }
        public string Amount { get; set; }
        public string LineItemType { get; set; }
        public string BalanceDueSatisfied { get; set; }
        public string MaskedAccountNumber { get; set; }
        public int ResponseCode { get; set; }
        public long ApprovalCode { get; set; }
        public string IsDeclined { get; set; }
        public string ResponseCodeDescriptor { get; set; }
        public long SequenceNumber { get; set; }
        public int CashBackAmount { get; set; }
        public string SignatureNeeded { get; set; }
        private string _xml;

        public AddTenderDebitResponse(int sessionId,
                                       TipoMensaje messageType, 
                                       int requestID,
                                       string returnFlag,
                                       string depositFlag,
                                       string voidFlag,
                                       string amount,
                                       string lineItemType,
                                       string balanceDueSatisfied,
                                       string maskedAccountNumber,
                                       int responseCode,
                                       long approvalCode,
                                       long sequenceNumber,
                                       int cashBackAmount,
                                       string isDeclined,
                                       string responseCodeDescriptor,
                                       string signatureNeeded) : base(sessionId, messageType)
        {
            RequestID = requestID;
            ReturnFlag = returnFlag;
            DepositFlag = depositFlag;
            VoidFlag = voidFlag;
            Amount = amount;
            LineItemType = lineItemType;
            BalanceDueSatisfied = balanceDueSatisfied;
            MaskedAccountNumber = maskedAccountNumber;
            ResponseCode = responseCode;
            ApprovalCode = approvalCode;
            IsDeclined = isDeclined;
            ResponseCodeDescriptor = responseCodeDescriptor;
            SequenceNumber = sequenceNumber;
            CashBackAmount = cashBackAmount;
            SignatureNeeded = signatureNeeded;
        }
        public override string TextoXML
        {
            //get => _xml = $"""
            //            <?xml version="1.0" encoding="UTF-8"?>
            //            <schema:AddTenderResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
            //              <AddTenderResult>
            //                <RequestID>{RequestID}</RequestID>
            //                <DebitInfo>
            //                  <ReturnFlag>{ReturnFlag}</ReturnFlag>
            //                  <DepositFlag>{DepositFlag}</DepositFlag>
            //                  <VoidFlag>{VoidFlag}</VoidFlag>
            //                  <Amount>{Amount}</Amount>
            //                  <LineItemType>{LineItemType}</LineItemType>
            //                  <BalanceDueSatisfied>{BalanceDueSatisfied}</BalanceDueSatisfied>
            //                  <LegalText>____________________________________</LegalText>
            //                  <LegalText>Acepto pagar el importe total arriba indicado</LegalText>
            //                  <LegalText>según el acuerdo con el emisor de la tarjeta</LegalText>
            //                  <ReferenceNumber></ReferenceNumber>
            //                  <MaskedAccountNumber>************{MaskedAccountNumber}</MaskedAccountNumber>
            //                  <ResponseCode>{ResponseCode}</ResponseCode>
            //                  <ApprovalCode>{ApprovalCode}</ApprovalCode>
            //                  <SequenceNumber>{SequenceNumber}</SequenceNumber>
            //                  <CashBackAmount>{CashBackAmount}</CashBackAmount>
            //                  <IsDeclined>{IsDeclined}</IsDeclined>
            //                  <ResponseCodeDescriptor>00 {ResponseCodeDescriptor}</ResponseCodeDescriptor>
            //                </DebitInfo>
            //                <SignatureNeeded>{SignatureNeeded}</SignatureNeeded>
            //              </AddTenderResult>
            //            </schema:AddTenderResponse>
            //            """;

            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddTenderResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddTenderResult>
                            <RequestID>{RequestID}</RequestID>
                            <DebitInfo>
                              <ReturnFlag>{ReturnFlag}</ReturnFlag>
                              <DepositFlag>{DepositFlag}</DepositFlag>
                              <VoidFlag>{VoidFlag}</VoidFlag>
                              <Amount>{Amount}</Amount>
                              <LineItemType>{LineItemType}</LineItemType>
                              <BalanceDueSatisfied>{BalanceDueSatisfied}</BalanceDueSatisfied>
                              <LegalText> ____________________________________ </LegalText>
                              <LegalText>I agree to pay the above total amount </LegalText>
                              <LegalText>according to the card issuer agreement</LegalText>
                              <ReferenceNumber />
                              <MaskedAccountNumber>************{MaskedAccountNumber}</MaskedAccountNumber>
                              <ResponseCode>-1</ResponseCode>
                              <ApprovalCode>{ApprovalCode}</ApprovalCode>
                              <SequenceNumber>{SequenceNumber}</SequenceNumber>
                              <CashBackAmount>{CashBackAmount}</CashBackAmount>
                              <IsDeclined>{IsDeclined}</IsDeclined>
                              <ResponseCodeDescriptor>00  {ResponseCodeDescriptor}                            </ResponseCodeDescriptor>
                            </DebitInfo>
                            <SignatureNeeded>{SignatureNeeded}</SignatureNeeded>
                          </AddTenderResult>
                        </schema:AddTenderResponse>
                        """;

        }
    }
}
