﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class AddTenderResponseError : Respuesta
    {
        public int RequestID { get; set; }
        public string Message { get; set; }
        public string ErrorCode { get; set; }
        private string _xml;
        public AddTenderResponseError(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string message,
                                 string errorCode) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Message = message;
            ErrorCode = errorCode;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddTenderResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddTenderResult>
                            <RequestID>{RequestID}</RequestID>
                            <ExceptionResult>
                              <Message>{Message}</Message>
                              <ErrorCode>{ErrorCode}</ErrorCode>
                            </ExceptionResult>
                          </AddTenderResult>
                        </schema:AddTenderResponse>
                        """;
        }

    }
}
