﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.CancelDatafono
{
    /// <summary>
    /// Respuesta cuando se cancela la transaccion por datafono
    /// </summary>
    public class CancelActionResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public CancelActionResponse(int sessionId,
                                    TipoMensaje messageType,
                                    int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
                    get => _xml = $"""
                         <?xml version="1.0" encoding="UTF-8"?>
                        <schema:CancelActionResponse xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <CancelActionResult>
                            <RequestID>{RequestID}</RequestID>
                            <ExceptionResult>
                              <Message xsi:nil="true"/>
                              <ErrorCode>UNSUPPORTED_OPERATION</ErrorCode>
                            </ExceptionResult>
                          </CancelActionResult>
                        </schema:CancelActionResponse>
                        """;
        }
    }
}
