﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de finalizar y pagar, cuarta respuesta
    /// </summary>
    public class GetTotalsResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string Total { get; set; }
        public string SubTotal { get; set; }
        public string Tax { get; set; }
        public string BalanceDue { get; set; }
        public string ChangeDue { get; set; }
        public string FoodstampChangeDue { get; set; }
        public string FoodstampTotal { get; set; }
        public string FoodstampBalanceDue { get; set; }
        public string CouponTotal { get; set; }
        public int TotalItems { get; set; }
        public int TotalCoupons { get; set; }
        public string TotalSavings { get; set; }
        public string TenderApplied { get; set; }
        private string _xml;

        public GetTotalsResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string total,
                                 string subtotal,
                                 string tax,
                                 string balanceDue, 
                                 string changeDue, 
                                 string foodstampChangeDue, 
                                 string foodstampTotal, 
                                 string foodstampBalanceDue, 
                                 string couponTotal, 
                                 int totalItems, 
                                 int totalCoupons, 
                                 string totalSavings, 
                                 string tenderApplied) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Total = total;
            SubTotal = subtotal;
            Tax = tax;
            BalanceDue = balanceDue;
            ChangeDue = changeDue;
            FoodstampChangeDue = foodstampChangeDue;
            FoodstampTotal = foodstampTotal;
            FoodstampBalanceDue = foodstampBalanceDue;
            CouponTotal = couponTotal;
            TotalItems = totalItems;
            TotalCoupons = totalCoupons;
            TotalSavings = totalSavings;
            TenderApplied = tenderApplied;
           
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:GetTotalsResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <GetTotalsResult>
                            <RequestID>{RequestID}</RequestID>
                            <TransactionTotals>
                              <Total>{Total}</Total>
                              <SubTotal>{SubTotal}</SubTotal>
                              <Tax>{Tax}</Tax>
                              <BalanceDue>{BalanceDue}</BalanceDue>
                              <ChangeDue>{ChangeDue}</ChangeDue>
                              <FoodstampChangeDue>{FoodstampChangeDue}</FoodstampChangeDue>
                              <FoodstampTotal>{FoodstampTotal}</FoodstampTotal>
                              <FoodstampBalanceDue>{FoodstampBalanceDue}</FoodstampBalanceDue>
                              <CouponTotal>{CouponTotal}</CouponTotal>
                              <TotalItems>{TotalItems}</TotalItems>
                              <TotalCoupons>{TotalCoupons}</TotalCoupons>
                              <TotalSavings>{TotalSavings}</TotalSavings>
                              <TenderApplied>{TenderApplied}</TenderApplied>
                            </TransactionTotals>
                          </GetTotalsResult>
                        </schema:GetTotalsResponse>
                        """;
            //get => _xml = $"""
            //            <?xml version="1.0" encoding="UTF-8"?>
            //            <schema:GetTotalsResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
            //              <GetTotalsResult>
            //                <RequestID>104</RequestID>
            //                <TransactionTotals>
            //                  <Total>3.99</Total>
            //                  <SubTotal>3.99</SubTotal>
            //                  <Tax>0.00</Tax>
            //                  <BalanceDue>3.99</BalanceDue>
            //                  <ChangeDue>0.00</ChangeDue>
            //                  <FoodstampChangeDue>0.00</FoodstampChangeDue>
            //                  <FoodstampTotal>0.00</FoodstampTotal>
            //                  <FoodstampBalanceDue>0.00</FoodstampBalanceDue>
            //                  <CouponTotal>0.00</CouponTotal>
            //                  <TotalItems>1</TotalItems>
            //                  <TotalCoupons>0</TotalCoupons>
            //                  <TotalSavings>0.00</TotalSavings>
            //                  <TenderApplied>0.00</TenderApplied>
            //                </TransactionTotals>
            //              </GetTotalsResult>
            //            </schema:GetTotalsResponse>
            //            """;
        }
    }
}
