﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de inicialización de POS.
    /// </summary>
    public class InitializeResponse : Respuesta
    {
        public int RequestID { get; private set; }
        private string _xml;

        public InitializeResponse(int sessionId,
                                  TipoMensaje messageType,
                                  int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }

        // P2L_3_POSBCStatusEvent
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:InitializeResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                            <InitializeResult>
                                <RequestID>{RequestID}</RequestID>
                            </InitializeResult>
                        </schema:InitializeResponse>
                        """;
        }
    }
}
