﻿using EvaPosSrvDTO;
using EvaPosSrvResp;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de agregar item - aca se manejan los errores de los productos
    /// producto con cantidad, sin cupon ,no encontrado y sin precio
    /// </summary>
    public class AddItemResponseError : Respuesta
    {
        public int RequestID { get; set; }
        public string Message { get; set; }
        public string ErrorCode { get; set; }
        private string _xml;

        public AddItemResponseError(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string message,
                                 string errorCode) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Message = message;
            ErrorCode = errorCode;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddItemResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddItemResult>
                            <RequestID>{RequestID}</RequestID>
                            <ExceptionResult>
                              <Message>{Message}</Message>
                              <ErrorCode>{ErrorCode}</ErrorCode>
                            </ExceptionResult>
                          </AddItemResult>
                        </schema:AddItemResponse>
                        """;

        }

        public override string ToString()
        {
            return String.Format("AddItemResponseError: RequestID {0}, Message {1}, ErrorCode {2}", RequestID, Message, ErrorCode);
        }
    }
}
