﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Evento para mandar el primer mensaje cuando se paga con tarjeta debito
    /// </summary>
    public class POSReceiptEventDebit : Respuesta
    {
        public int RequestID { get; set; }
        public string Text { get; set; }
        private string _xml;

        public POSReceiptEventDebit(int sessionId,
                                    TipoMensaje messageType,
                                    int requestID,
                                    string text) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Text = text;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSReceiptEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"
                                                UpdateType="Modify">
                          <RequestID>{RequestID}</RequestID>
                          <Type>Customer</Type>
                          <Index>0</Index>
                          <Section>Trailer</Section>
                          <Group>{RequestID}</Group>
                          <FormattedReceiptLineList>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Trailer</LineCategory>
                              <LineType>WorkstationInfo</LineType>
                              <TextReceiptLine>
                                <Text>{Text}                     1</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Trailer</LineCategory>
                              <LineType>LoyaltyMessages</LineType>
                              <TextReceiptLine>
                                <Text>***************************************</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Trailer</LineCategory>
                              <LineType>LoyaltyMessages</LineType>
                              <TextReceiptLine>
                                <Text>   Thank you for learning with us.</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Trailer</LineCategory>
                              <LineType>LoyaltyMessages</LineType>
                              <TextReceiptLine>
                                <Text>***************************************</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                          </FormattedReceiptLineList>
                        </schema:POSReceiptEvent>
                        """;
        }

    }
}
