﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class POSReceiptEventFooter : Respuesta
    {
        public int RequestID { get; set; }
        public string Type { get; set; }
        public int Index { get; set; }
        public string ArticulosVendidos { get; set; }
        public string Section { get; set; }
        public int Group { get; set; }
        public int Feeds { get; set; }
        public string Align { get; set; }
        public string LineCategory { get; set; }
        public string LineType { get; set; }
        public string Text { get; set; }
        //Impuestos
        public int TipoImpuestoC { get; set; }
        public int TipoImpuestoD { get; set; }
        public double CompraC { get; set; }
        public double CompraD { get; set; }
        public double BaseImpuestoC { get; set; }
        public double BaseImpuestoD { get; set; }
        public double ImpuestoC { get; set; }
        public double ImpuestoD { get; set; }
        public double TotalCompra { get; set; }
        public double TotalBaseImp { get; set; }
        public double TotalImp { get; set; }
        //Filas de los impuestos
        public string Fila1Imp { get; set; }
        public string Fila2Imp { get; set; }
        public string Fila3Imp { get; set; }
        public string FilaTotalImp { get; set; }

        private string _xml;

        public POSReceiptEventFooter(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string type,
                                 int index,
                                 string section,
                                 int group,
                                 int feeds,
                                 string align,
                                 string lineCategory,
                                 string lineType,
                                 string text,
                                 string articulosVendidos,
                                 string fila1Imp,
                                 string fila2Imp,
                                 string fila3Imp,
                                 string filaTotalImp) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Type = type;
            Index = index;
            Section = section;
            Group = group;
            Feeds = feeds;
            Align = align;
            LineCategory = lineCategory;
            LineType = lineType;
            Text = text;
            ArticulosVendidos = articulosVendidos;
            Fila1Imp = fila1Imp;
            Fila2Imp = fila2Imp;
            Fila3Imp = fila3Imp;
            FilaTotalImp = filaTotalImp;

            //TipoImpuestoC = tipoImpuestoC;
            //TipoImpuestoD = tipoImpuestoD;
            //CompraC = compraC;
            //CompraD = compraD;
            //BaseImpuestoC = baseImpuestoC;
            //BaseImpuestoD = baseImpuestoD;
            //ImpuestoC = impuestoC;
            //ImpuestoD = impuestoD;
            //TotalCompra = totalCompra;
            //TotalBaseImp = totalBaseImp;
            //TotalImp = totalImp;

        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSReceiptEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"
                                                UpdateType="Add">
                          <RequestID>{RequestID}</RequestID>
                          <Type>{Type}</Type>
                          <Index>{Index}</Index>
                          <Section>{Section}</Section>
                          <Group>{Group}</Group>
                          <FormattedReceiptLineList>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{Text}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{ArticulosVendidos}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text> **** DETALLES DE LOS IMPUESTOS ****</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>Tipo      Compra      Base/Imp      IMP</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>----      ------      ------      ----</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{Fila1Imp}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{Fila2Imp}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{Fila3Imp}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>-------    -------    -------    -----</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{FilaTotalImp}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                          <FormattedReceiptLine>
                          <Feeds>{Feeds}</Feeds> 
                          <Align>{Align}</Align>
                          <LineCategory>{LineCategory}</LineCategory>
                          <LineType>{LineType}</LineType>
                          <TextReceiptLine>
                            <Text>-------    -------    -------    -----</Text>
                          </TextReceiptLine>
                        </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>    REGIMEN COMUN     </Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>Lo Atendio: ROCIO SERRANO</Text>
                              </TextReceiptLine>
                        </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>*DCTO/EQUIVALENTE: BC36-00247754*</Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>RANGO: BC3600186000-BC3699999999</Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                         <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>Resol: 4027705927 de Abr 12/2022</Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>          GARDENIA     </Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>         </Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>     ||||||||||||||||||||||||     </Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds> 
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text> </Text>
                              </TextReceiptLine>
                         </FormattedReceiptLine>
                        <FormattedReceiptLine>
                             <Feeds>{Feeds}</Feeds> 
                             <Align>{Align}</Align>
                             <LineCategory>{LineCategory}</LineCategory>
                             <LineType>{LineType}</LineType>
                             <TextReceiptLine>
                               <Text>Mzo/1/2023 18:48 0001208 0295 4242218</Text>
                             </TextReceiptLine>
                        </FormattedReceiptLine>
                        <FormattedReceiptLine>
                             <Feeds>{Feeds}</Feeds> 
                             <Align>{Align}</Align>
                             <LineCategory>{LineCategory}</LineCategory>
                             <LineType>{LineType}</LineType>
                             <TextReceiptLine>
                               <Text>    PROHIBIDA LA VENTA DE LICORES    </Text>
                             </TextReceiptLine>
                        </FormattedReceiptLine>
                        <FormattedReceiptLine>
                             <Feeds>{Feeds}</Feeds> 
                             <Align>{Align}</Align>
                             <LineCategory>{LineCategory}</LineCategory>
                             <LineType>{LineType}</LineType>
                             <TextReceiptLine>
                               <Text>         A MENORES DE EDAD     </Text>
                             </TextReceiptLine>
                        </FormattedReceiptLine>
                        </FormattedReceiptLineList>
                        </schema:POSReceiptEvent>
                        """;
        }
    }
}

