﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de finalizar y pagar, primera respuesta
    /// </summary>
    public class POSReceiptEventResponse : Respuesta
    {
        public int RequestID { get; set; }
        public int Group { get; set; }
        public string Text1 { get; set; }
        public string Text2 { get; set; }
        private string _xml;

        public POSReceiptEventResponse(int sessionId,
                                        TipoMensaje messageType, 
                                        int requestID,
                                        int group,
                                        string text1,
                                        string text2) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Group = group;
            Text1 = text1;
            Text2 = text2;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSReceiptEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"
                                                UpdateType="Add">
                          <RequestID>{RequestID}</RequestID>
                          <Type>Customer</Type>
                          <Index>0</Index>
                          <Section>Body</Section>
                          <Group>{Group}</Group>
                          <FormattedReceiptLineList>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>LineItem</LineCategory>
                              <LineType>TransactionTotal</LineType>
                              <TextReceiptLine>
                                <Text>       TAX               {Text1}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                            <Feeds>1</Feeds>
                            <Align>center</Align>
                            <LineCategory>LineItem</LineCategory>
                            <LineType>TransactionTotal</LineType>
                            <TextReceiptLine>
                                <Text>   **** BALANCE               {Text2}</Text>
                            </TextReceiptLine>
                        </FormattedReceiptLine>
                          </FormattedReceiptLineList>
                        </schema:POSReceiptEvent>
                        """;
        }
    }
}
