﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Envia una respuesta(evento) de cual es el estado de la impresora. 
    /// La realiza cuando viene un request de ReportStatusEvents(Cuando inicia la pos)
    /// </summary>
    public class PrinterStatusResponse : Respuesta
    {
        public string Severity { get; set; }
        public string Status { get; set; }
        public string StatusMessage { get; set; }
        private string _xml;

        public PrinterStatusResponse(int sessionId,
                                     TipoMensaje messageType, 
                                     string severity, 
                                     string status, 
                                     string statusMessage) : base(sessionId, messageType)
        {
            Severity = severity;
            Status = status;
            StatusMessage = statusMessage;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSBCStatusEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <PrinterStatus>
                            <Severity>{Severity}</Severity>
                            <Status>{Status}</Status>
                            <StatusMessage>{StatusMessage}</StatusMessage>
                          </PrinterStatus>
                        </schema:POSBCStatusEvent>
                        """;
        }
    }
}
