﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición del tercer mensaje de la posbc
    /// </summary>
    public class QueryStatusResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string POSBCStatus { get; set; }
        public int Version { get; set; }
        public int Release { get; set; }
        public int MaintenanceLevel { get; set; }
        public string Description { get; set; }
        public string CurrentDateAndTime { get; set; }
        public int LastSuccessfulRequestID { get; set; }
        public bool IsInTransaction { get; set; }
        private string _xml;

        public QueryStatusResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string posbStatus,
                                 int version,
                                 int release,
                                 int maintenanceLevel,
                                 string description,
                                 string currentDateAndTime,
                                 int lastSuccessfulRequestId,
                                 bool isInTransaction) : base(sessionId, messageType)
        {
            RequestID = requestID;
            POSBCStatus = posbStatus;
            Version = version;
            Release = release;
            MaintenanceLevel = maintenanceLevel;
            Description = description;
            CurrentDateAndTime = currentDateAndTime;
            LastSuccessfulRequestID = lastSuccessfulRequestId;
            IsInTransaction = isInTransaction;

        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:QueryStatusResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                        <QueryStatusResult>
                            <RequestID>{RequestID}</RequestID>
                            <APIHistory />
                            <POSBCStatus>{POSBCStatus}</POSBCStatus>
                            <POSBCVersion>
                            <Version>{Version}</Version>
                            <Release>{Release}</Release>
                            <MaintenanceLevel>{MaintenanceLevel}</MaintenanceLevel>
                            <Description>{Description}</Description>
                            </POSBCVersion>
                            <CurrentDateAndTime>{CurrentDateAndTime}</CurrentDateAndTime>
                            <LastSuccessfulRequestID>{LastSuccessfulRequestID}</LastSuccessfulRequestID>
                            <IsInTransaction>{IsInTransaction}</IsInTransaction>
                        </QueryStatusResult>
                        </schema:QueryStatusResponse>
                        """;
        }


    }
}
