﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class RemoveReceiptLinesResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public RemoveReceiptLinesResponse(int sessionId,
                                       TipoMensaje messageType,
                                       int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:RemoveReceiptLinesResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <RemoveReceiptLinesResult>
                            <RequestID>{RequestID}</RequestID>
                          </RemoveReceiptLinesResult>
                        </schema:RemoveReceiptLinesResponse>
                        """;
        }
    }
}
