﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición del cuarto mensaje de la posbc - (ReportStatusEventsResult)
    /// </summary>
    public class ReportStatusEventsResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public ReportStatusEventsResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:ReportStatusEventsResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                        <ReportStatusEventsResult>
                            <RequestID>{RequestID}</RequestID>
                        </ReportStatusEventsResult>
                        </schema:ReportStatusEventsResponse>
                        """;
        }
    }
}
