﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.Reprint
{
    public class ReprintReceiptsResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public ReprintReceiptsResponse(int sessionId,
                                        TipoMensaje messageType,
                                        int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:ReprintReceiptsResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <ReprintReceiptsResult>
                            <RequestID>{RequestID}</RequestID>
                          </ReprintReceiptsResult>
                        </schema:ReprintReceiptsResponse>
                        """;
        }
    }
}
