﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
//using System.Runtime.Remoting.Lifetime;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.RestriccionEdad
{
    /// <summary>
    /// Respuesta procesada de la restriccion de edad
    /// </summary>
    public class AddCustomerBirthdateResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public AddCustomerBirthdateResponse(int sessionId,
                                            TipoMensaje messageType, 
                                            int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddCustomerBirthdateResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddCustomerBirthdateResult>
                            <RequestID>{RequestID}</RequestID>
                          </AddCustomerBirthdateResult>
                        </schema:AddCustomerBirthdateResponse>
                        """;

        }
    }
}
