﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class SignOffResponse : Respuesta
    {
        public string RequestID { get; set; }
        private string _xml;

        public SignOffResponse(int sessionId,
                                      TipoMensaje messageType,
                                      string requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:SignOffResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <SignOffResult>
                            <RequestID>{RequestID}</RequestID>
                          </SignOffResult>
                        </schema:SignOffResponse>
                        """;
        }
    }
}
