using System;
using System.Xml;
using EvaPOS_API_FRAME.Adaptadores;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;

// ****************************************************************
//
//     ESPACIO DE NOMBRES PARA IMPLEMENTAR ADAPTADORES Y RESPUESTAS
//
// ****************************************************************
namespace EvaPosSrvRespImp
{
    /// <summary>
    /// Clase para inicializar el directorio de adaptadores de entrada.
    /// Los adaptadores de entrada inicializan al dto asociada con el mensaje de entrada.
    /// Para agregar un adaptador de entrada, modifique el método ' public static IniciaDirectorioAdaptadores Cargar()'
    /// agregando la nueva instancia del objeto adaptador, usando el método 'AgregaAdaptador'. Ejemplo:
    ///
    ///        public static IniciaDirectorioAdaptadores Cargar() 
    ///         {
    ///             return new IniciaDirectorioAdaptadores()
    ///            .AgregaAdaptador(new AdaptadorInitializeRequest())
    ///            .AgregarAdaptador(new AdaptadorQueryStatusRequest());
    ///         }
    ///
    ///         Agrega nueva instancia del AdaptadorQueryStatusRequest() al directorio de adaptadores.
    /// </summary>
    public class IniciaDirectorioAdaptadores
    {
        public DirectorioAdaptadoresDTO DirectorioAdaptadores  {get; private set;} = new DirectorioAdaptadoresDTO();

        public IniciaDirectorioAdaptadores AgregaAdaptador(IAdaptadorDTO adaptador)
        {
            DirectorioAdaptadores.AgregaAdaptador(adaptador);
            return this;
        }

        public static IniciaDirectorioAdaptadores Cargar() 
        {
            return new IniciaDirectorioAdaptadores()
            .AgregaAdaptador(new AdaptadorInitializeRequest())
            .AgregaAdaptador(new AdaptadorQueryStatusRequest())
            .AgregaAdaptador(new AdaptadorReportStatusEventsRequest())
            .AgregaAdaptador(new AdaptadorAddItemRequest())
            .AgregaAdaptador(new AdaptadorSignOffRequest())
            .AgregaAdaptador(new AdaptadorAddReceiptLinesRequest())
            .AgregaAdaptador(new AdaptadorGetTotalsRequest())
            .AgregaAdaptador(new AdaptadorAddTenderDebitRequest())
            .AgregaAdaptador(new AdaptadorPrintCurrentReceipts())
            .AgregaAdaptador(new AdaptadorReprintReceiptsRequest())
            .AgregaAdaptador(new AdaptadorTerminateRequest())
            .AgregaAdaptador(new AdaptadoresVoidTransactionRequest())
            .AgregaAdaptador(new AdaptadorRemoveReceiptLines())
            .AgregaAdaptador(new AdaptadorCancelAction())
            .AgregaAdaptador(new AdaptadorAddCustomerBirthdateRequest())
            .AgregaAdaptador(new AdaptadorAddCustomerRequest())
            .AgregaAdaptador(new AdaptadorSuspendTransactionRequest());
        }
    }
    
}
