﻿using System.Diagnostics;
using System.Text;
using Serilog;
using GatewaySCO;
using gatewayGK.ComandosGk;
using SCOGateway.POSGk;
using EvaPosSrvDTO;
using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvResp;
using Newtonsoft.Json;
using IO.Swagger.Model;
using static IO.Swagger.Model.ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig;

namespace pruebas
{
    public class DatosBody
    {
        public ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig dato;
    }

    public class PruebaJsonSubtotal
    {
        static void Main(string[] args)
        {
            // Instancia Serilog según parámetros en archivo de configuración.
            Log.Logger = new LoggerConfiguration()
                .MinimumLevel.Verbose()
                .WriteTo.File("./logs/log-.txt", rollingInterval: RollingInterval.Day)
                .WriteTo.Console()
                .CreateLogger();

            Log.Information("*** Inicio pruebas PruebaJsonSubtotal ***");
            PruebaJsonSubtotal p = new();
            p.Ejecutar();
        }

        public void Ejecutar()
        {

            ComGkSoftwarePosApiModelConfigProcessActionPositionOperationConfig configReq = new(
                false,  //(bool? forceQuantityInput = default(bool?)
                1000000000, //double? pricePositionLimit = default(double?)
                true,   //bool? pricePositionZeroAllowed = default(bool?)
                -1.0,   // double? priceTransactionLimit = default(double?)
                100.0,  //priceDifferencePercentPositionLimit = default(double?)
                99999999.0, // priceDifferenceAbsolutePositionLimit = default(double?)
                PriceDifferenceLimitExceedActionEnum.Authorize, //priceDifferenceLimitExceedAction = default(PriceDifferenceLimitExceedActionEnum)
                PriceNegDifferenceLimitExceedActionEnum.Unchecked, // PriceNegDifferenceLimitExceedActionEnum priceNegDifferenceLimitExceedAction = default(PriceNegDifferenceLimitExceedActionEnum), 
                CloseCurrentEnum.Disabled, // CloseCurrentEnum closeCurrent = default(CloseCurrentEnum), 
                ClosePreviousEnum.Required, // ClosePreviousEnum closePrevious = default(ClosePreviousEnum), 
                false, // bool? filterResult = default(bool?), 
                false, // bool? allowedWithWeight = default(bool?), 
                false, // bool? allowedWithLength = default(bool?), 
                false, // bool? allowedWithArea = default(bool?),
                false, // bool? allowedWithVolume = default(bool?), 
                false, // bool? allowedWithMeasure = default(bool?), 
                99999, // int? maximumQuantity = default(int?), 
                1, // int? minimumQuantity = default(int?),
                QuantityInputOrderEnum.BeforeOrAfter, // QuantityInputOrderEnum quantityInputOrder = default(QuantityInputOrderEnum),
                PriceInputOrderEnum.BeforeOrAfter, // PriceInputOrderEnum priceInputOrder = default(PriceInputOrderEnum), 
                QuantityLimitExceedActionEnum.Forbid, //  QuantityLimitExceedActionEnum quantityLimitExceedAction = default(QuantityLimitExceedActionEnum),
                AmountLimitExceedActionEnum.Forbid, // AmountLimitExceedActionEnum amountLimitExceedAction = default(AmountLimitExceedActionEnum), 
                0.0, //  double? weightUnitFactor = default(double?), 
                0.0, // double? measureUnitFactor = default(double?),
                PriceDeviationTypeEnum.All, // PriceDeviationTypeEnum priceDeviationType = default(PriceDeviationTypeEnum)
                PriceNegDeviationTypeEnum.All, // PriceNegDeviationTypeEnum priceNegDeviationType = default(PriceNegDeviationTypeEnum),
                "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");

            string jsonReq = JsonConvert.SerializeObject(configReq);

            string body = $"{{ \"com.gk_software.pos.api.model.config.process.action.PositionOperationConfig\": {jsonReq} }}";

           

            Log.Information("json subtotal: {jsonReq}", body);

        }
    }

}
