namespace POSGkSwaggerModel
{
    /// <summary>
    /// LayawaySummary &lt;emph&gt;undocumented&lt;/emph&gt;
    /// </summary>
    public record comGkSoftwareGkrApiLayawayDtoLayawaySummary	{
        /// <summary>
        /// BusinessUnitGroup identificator of the business unit, where the Layaway was created
        /// </summary>
        /// <value>BusinessUnitGroup identificator of the business unit, where the Layaway was created</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// ID of the Layaway (&#x3D; Transaction ID of Layaway create TX)
        /// </summary>
        /// <value>ID of the Layaway (&#x3D; Transaction ID of Layaway create TX)</value>
        public string layawayID { get; init; }
        /// <summary>
        /// Timestamp when Layaway was created; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>Timestamp when Layaway was created; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string createTimestamp { get; init; }
        /// <summary>
        /// UTC0 timestamp when Layaway was created; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>UTC0 timestamp when Layaway was created; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? createTimestampUTC0 { get; init; }
        /// <summary>
        /// Status of the Layaway. Supported are:ACTIVEVOIDED FULLY_PAIDCLAIMEDTERMINATEDEXPIREDREBOOKED
        /// </summary>
        /// <value>Status of the Layaway. Supported are:ACTIVEVOIDED FULLY_PAIDCLAIMEDTERMINATEDEXPIREDREBOOKED</value>
        public string statusCode { get; init; }
        /// <summary>
        /// Layaway is blocked while there is a suspended, non-retrieved  Layaway relevant TX .Its not allowed to do anything else than to retrieve this suspend and finalize it. Or to expire/rebook/terminate a layaway.
        /// </summary>
        /// <value>Layaway is blocked while there is a suspended, non-retrieved  Layaway relevant TX .Its not allowed to do anything else than to retrieve this suspend and finalize it. Or to expire/rebook/terminate a layaway.</value>
        public bool? suspendedFlag { get; init; }
        /// <summary>
        /// To know if layaway was already rebooked even if it is in CLAIMED status.Default: falseWill only be changed if Layaway Rebooking TX is consumed.
        /// </summary>
        /// <value>To know if layaway was already rebooked even if it is in CLAIMED status.Default: falseWill only be changed if Layaway Rebooking TX is consumed.</value>
        public bool? rebookedFlag { get; init; }
        /// <summary>
        /// To know if layaway was already claimed even if it is in REBOOKED status.Default: falseWill only be changed if Layaway Claimed TX  is consumed.
        /// </summary>
        /// <value>To know if layaway was already claimed even if it is in REBOOKED status.Default: falseWill only be changed if Layaway Claimed TX  is consumed.</value>
        public bool? claimedFlag { get; init; }
        /// <summary>
        /// Incrementing number counting modifications of a layaway, so that it is possible to find out which LW manipulation was the last
        /// </summary>
        /// <value>Incrementing number counting modifications of a layaway, so that it is possible to find out which LW manipulation was the last</value>
        public int? laywayUpdateSequence { get; init; }
        /// <summary>
        /// N/A
        /// </summary>
        /// <value>N/A</value>
        public string pendingTransactionID { get; init; }
        /// <summary>
        /// Last change of StatusCode; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>Last change of StatusCode; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string lastUpdateTimeStamp { get; init; }
        /// <summary>
        /// UTC0 timestamp of the last change of StatusCode; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>UTC0 timestamp of the last change of StatusCode; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? lastUpdateTimeStampUTC0 { get; init; }
        /// <summary>
        /// Assigned customer ID to Layaway.
        /// </summary>
        /// <value>Assigned customer ID to Layaway.</value>
        public string customerID { get; init; }
        /// <summary>
        /// Expiration date of the Layaway (including the tolerance time). Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>Expiration date of the Layaway (including the tolerance time). Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string expirationDate { get; init; }
        /// <summary>
        /// UTC0 time of expiration date. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>UTC0 time of expiration date. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? expirationDateUTC0 { get; init; }
        /// <summary>
        /// Expiration date for customer (excluding the tolerance time). Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>Expiration date for customer (excluding the tolerance time). Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string expirationNotificationDate { get; init; }
        /// <summary>
        /// UTC0 time of expiration date for customer. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>UTC0 time of expiration date for customer. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? expirationNotificationDateUTC0 { get; init; }
        /// <summary>
        /// Termination date of the layaway. This is the date after no futher modifications of layaway are not allowed. Be it payment or whatever. Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>Termination date of the layaway. This is the date after no futher modifications of layaway are not allowed. Be it payment or whatever. Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string terminationDate { get; init; }
        /// <summary>
        /// UTC0 time of TerminationDate; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>UTC0 time of TerminationDate; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? terminationDateUTC0 { get; init; }
        /// <summary>
        /// Total order value of the Layaway.
        /// </summary>
        /// <value>Total order value of the Layaway.</value>
        public double? totalAmount { get; init; }
        /// <summary>
        /// Total of the already payed down payments of the Layaway.
        /// </summary>
        /// <value>Total of the already payed down payments of the Layaway.</value>
        public double? totalDownPaymentsAmount { get; init; }
        /// <summary>
        /// The fee has to be paid in case the customer retrieves its money back from an expired Layaway.
        /// </summary>
        /// <value>The fee has to be paid in case the customer retrieves its money back from an expired Layaway.</value>
        public double? penaltyFee { get; init; }
        /// <summary>
        /// The fee has to be paid in case the customer is voiding the complete Layaway.
        /// </summary>
        /// <value>The fee has to be paid in case the customer is voiding the complete Layaway.</value>
        public double? cancellationFee { get; init; }
        /// <summary>
        /// List of Layaway line items
        /// </summary>
        /// <value>List of Layaway line items</value>
        public List<comGkSoftwareGkrApiLayawayDtoLayawayLineItem> LayawayLineItemList { get; init; }
        /// <summary>
        /// Checksum of all related layaway transactions, used to guaranteee the state of the layaway while modifying it by storing additional transaction.
        /// </summary>
        /// <value>Checksum of all related layaway transactions, used to guaranteee the state of the layaway while modifying it by storing additional transaction.</value>
        public string layawayCorrelationChecksum { get; init; }
        /// <summary>
        /// TransactionID for &#39;Latest Order Position Relevant TX&#39;
        /// </summary>
        /// <value>TransactionID for &#39;Latest Order Position Relevant TX&#39;</value>
        public string latestOrderPositionTransactionID { get; init; }
        /// <summary>
        /// To know if the expiration date of a layaway was already extended.Default: falseWill only be changed if Extended Layaway TX is consumed.
        /// </summary>
        /// <value>To know if the expiration date of a layaway was already extended.Default: falseWill only be changed if Extended Layaway TX is consumed.</value>
        public bool? expirationDateExtendedFlag { get; init; }
        /// <summary>
        /// standard extension pattern for extending calculation in project
        /// </summary>
        /// <value>standard extension pattern for extending calculation in project</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// standard extension pattern for extending calculation in project
        /// </summary>
        /// <value>standard extension pattern for extending calculation in project</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// standard extension pattern for extending calculation in project
        /// </summary>
        /// <value>standard extension pattern for extending calculation in project</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// standard extension pattern for extending calculation in project
        /// </summary>
        /// <value>standard extension pattern for extending calculation in project</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// standard extension pattern for extending calculation in project
        /// </summary>
        /// <value>standard extension pattern for extending calculation in project</value>
        public string xxcustom01 { get; init; }
	}
}
