namespace POSGkSwaggerModel
{
    /// <summary>
    /// PosUOMItemDO &lt;p&gt;This object contains item data for one specific unit of measure. The object is a projection from the item domain object.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemDO	{
        /// <summary>
        /// &lt;p&gt;A code to denote the tax exemption status from sales and use tax.&lt;br /&gt; (00/null - normal, item is taxable, 01 - no tax).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code to denote the tax exemption status from sales and use tax.&lt;br /&gt; (00/null - normal, item is taxable, 01 - no tax).&lt;br /&gt;&lt;/p&gt;</value>
        public taxExemptCodeEnum? taxExemptCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Deposit type of the item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Deposit type of the item.&lt;br /&gt;&lt;/p&gt;</value>
        public depositTypeCodeEnum? depositTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Getter for inner key class.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Getter for inner key class.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemDOkey key { get; init; }
        /// <summary>
        /// &lt;p&gt;Localized Unit of measure name.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Localized Unit of measure name.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomName { get; init; }
        /// <summary>
        /// &lt;p&gt;The name by which the item is known.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The name by which the item is known.&lt;br /&gt;&lt;/p&gt;</value>
        public string name { get; init; }
        /// <summary>
        /// &lt;p&gt;The textural description of the item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The textural description of the item.&lt;br /&gt;&lt;/p&gt;</value>
        public string description { get; init; }
        /// <summary>
        /// &lt;p&gt;Class code (eg. empties, fresh food). Usage example: Via customizing is possible to disable the registration of items with this class code.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Class code (eg. empties, fresh food). Usage example: Via customizing is possible to disable the registration of items with this class code.&lt;br /&gt;&lt;/p&gt;</value>
        public string classCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A tax group which links a tax authority to the merchandise to which the tax applies.&lt;br /&gt; If no taxGroupID is delivered, the taxGroup with 0% is to be searched out and used. If no taxGroup with 0% exists, the import of the item fails.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A tax group which links a tax authority to the merchandise to which the tax applies.&lt;br /&gt; If no taxGroupID is delivered, the taxGroup with 0% is to be searched out and used. If no taxGroup with 0% exists, the import of the item fails.&lt;br /&gt;&lt;/p&gt;</value>
        public string taxGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;An alternative tax group which links a tax authority to the merchandise to which the tax applies.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;An alternative tax group which links a tax authority to the merchandise to which the tax applies.&lt;br /&gt;&lt;/p&gt;</value>
        public string alternativeTaxGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;The Taxable Group Receipt Print Code.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The Taxable Group Receipt Print Code.&lt;br /&gt;&lt;/p&gt;</value>
        public string taxGroupReceiptPrintCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Specifies the category of the item (e.g. single item, item variant, display).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Specifies the category of the item (e.g. single item, item variant, display).&lt;br /&gt;&lt;/p&gt;</value>
        public string itemUsageTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The duration of the item&#39;s warranty in months&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The duration of the item&#39;s warranty in months&lt;br /&gt;&lt;/p&gt;</value>
        public double? warrantyPeriod { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the number of weight units of measure for the tare.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the number of weight units of measure for the tare.&lt;br /&gt;&lt;/p&gt;</value>
        public string tareId { get; init; }
        /// <summary>
        /// &lt;p&gt;Tare UOM code.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Tare UOM code.&lt;br /&gt;&lt;/p&gt;</value>
        public string tareUomCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Reference to the POSDepartment the item belongs to&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reference to the POSDepartment the item belongs to&lt;br /&gt;&lt;/p&gt;</value>
        public string posDepartmentID { get; init; }
        /// <summary>
        /// &lt;p&gt;The main POS item identifier&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main POS item identifier&lt;br /&gt;&lt;/p&gt;</value>
        public string mainPOSItemId { get; init; }
        /// <summary>
        /// &lt;p&gt;References the default merchandise hierarchy group the item belongs to&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;References the default merchandise hierarchy group the item belongs to&lt;br /&gt;&lt;/p&gt;</value>
        public string mainMerchandiseHierarchyGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;Localized default merchandise hierarchy group name.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Localized default merchandise hierarchy group name.&lt;br /&gt;&lt;/p&gt;</value>
        public string mainMerchandiseHierarchyGroupName { get; init; }
        /// <summary>
        /// &lt;p&gt;Localized default merchandise hierarchy group description.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Localized default merchandise hierarchy group description.&lt;br /&gt;&lt;/p&gt;</value>
        public string mainMerchandiseHierarchyGroupDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;Selling rules for this item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Selling rules for this item&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareSweeSesApiServerMditemSellingRuleDtoSoitemSellingRuleSO itemSellingRule { get; init; }
        /// <summary>
        /// &lt;p&gt;This code defines the current state of an item within the retail store.&lt;br /&gt; An item&#39;s state limits what actions may be taken on an item in terms of ordering, receiving, selling, returns, transfers, counting and so on.&lt;br /&gt; Sample statuses include active, inactive, discontinued, pending, etc.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This code defines the current state of an item within the retail store.&lt;br /&gt; An item&#39;s state limits what actions may be taken on an item in terms of ordering, receiving, selling, returns, transfers, counting and so on.&lt;br /&gt; Sample statuses include active, inactive, discontinued, pending, etc.&lt;br /&gt;&lt;/p&gt;</value>
        public string statusCode { get; init; }
        /// <summary>
        /// &lt;p&gt;List of item collections&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of item collections&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemCollection> ItemCollectionList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of the item associations&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of the item associations&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemRelatedItemAssociation> RelatedItemAssociationList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of item characteristics with values&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of item characteristics with values&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemCharacteristic> ItemCharacteristicList { get; init; }
        /// <summary>
        /// Gets or Sets ItemFeatureList
        /// </summary>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemFeature> ItemFeatureList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of POS item ID&#39;s (EANs)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of POS item ID&#39;s (EANs)&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemPosIdentity> PosIdentityList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of selling prices&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of selling prices&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemSellingPriceDO> SellingPriceList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of deposits&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of deposits&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemDepositCollection> ItemDepositCollectionList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of text to UOMItem&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of text to UOMItem&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemText> UomItemTextList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of merchandise hierarchy groups&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of merchandise hierarchy groups&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdItemDtoDomPosPosUOMItemMHG> ItemMHGList { get; init; }
        /// <summary>
        /// &lt;p&gt;Sales restriction for this item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sales restriction for this item&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdSalesRestrictionDtoSoSalesRestrictionSO> SalesRestrictionList { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the item is inventory-tracked&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the item is inventory-tracked&lt;br /&gt;&lt;/p&gt;</value>
        public bool? updateStockFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Code of the base unit of measure. The base unit of measure is automatically selected if the item is registered by ItemID.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Code of the base unit of measure. The base unit of measure is automatically selected if the item is registered by ItemID.&lt;br /&gt;&lt;/p&gt;</value>
        public string baseUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this item cannot be considered within physical inventories&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this item cannot be considered within physical inventories&lt;br /&gt;&lt;/p&gt;</value>
        public bool? prohibitedForPhysicalInventoryFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The number of business days the SHELF ITEM may be displayed for sale to customers and after which must be removed.&lt;br /&gt; This attribute is used for perishable produce items, drugs, and other time sensitive items (like newspapers).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of business days the SHELF ITEM may be displayed for sale to customers and after which must be removed.&lt;br /&gt; This attribute is used for perishable produce items, drugs, and other time sensitive items (like newspapers).&lt;br /&gt;&lt;/p&gt;</value>
        public int? minimumShelfLifeDayCount { get; init; }
        /// <summary>
        /// &lt;p&gt;Type of the label&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type of the label&lt;br /&gt;&lt;/p&gt;</value>
        public string labelType { get; init; }
        /// <summary>
        /// &lt;p&gt;A code which is used by the loyalty engine in order to determine whether the item can get rebate/points. Possible values: 0..9&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code which is used by the loyalty engine in order to determine whether the item can get rebate/points. Possible values: 0..9&lt;br /&gt;&lt;/p&gt;</value>
        public string discountTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Time range (count of days) between production date and best-before date&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Time range (count of days) between production date and best-before date&lt;br /&gt;&lt;/p&gt;</value>
        public int? globalLifeDayCount { get; init; }
        /// <summary>
        /// &lt;p&gt;Percentage for calculating the shelf life day count&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Percentage for calculating the shelf life day count&lt;br /&gt;&lt;/p&gt;</value>
        public double? shelfLifeDayCountPercent { get; init; }
        /// <summary>
        /// &lt;p&gt;The unit of measure of the &#39;day count&#39; elements (day or week)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unit of measure of the &#39;day count&#39; elements (day or week)&lt;br /&gt;&lt;/p&gt;</value>
        public string dayCountUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Default receiving place&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Default receiving place&lt;br /&gt;&lt;/p&gt;</value>
        public string defaultReceivingLocation { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether the item is a concession item. Concession items are not maintained by the retailer, but by a vendor itself. E.g. snacks and food in vending machines.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether the item is a concession item. Concession items are not maintained by the retailer, but by a vendor itself. E.g. snacks and food in vending machines.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? concessionItemFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether the item is a cost item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether the item is a cost item&lt;br /&gt;&lt;/p&gt;</value>
        public bool? costItemFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines the merchandise planning - the way, how the item is ordered (automatically, manually, not orderable, ..).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines the merchandise planning - the way, how the item is ordered (automatically, manually, not orderable, ..).&lt;br /&gt;&lt;/p&gt;</value>
        public string merchandisePlanningTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Reference to the main supplier of this item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reference to the main supplier of this item&lt;br /&gt;&lt;/p&gt;</value>
        public string mainSupplierId { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this item is sold via VENSAFE.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this item is sold via VENSAFE.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? venSafeFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Consumer package gross content of the base UOM of the item&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * e.g. can of peaches&lt;br /&gt;    * gross content &#x3D; 500&lt;br /&gt;    * net content &#x3D; 385&lt;br /&gt;    * contents UOM &#x3D; ml&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;Consumer package gross content of the base UOM of the item&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * e.g. can of peaches&lt;br /&gt;    * gross content &#x3D; 500&lt;br /&gt;    * net content &#x3D; 385&lt;br /&gt;    * contents UOM &#x3D; ml&lt;br /&gt;&lt;/pre&gt;</value>
        public double? baseUOMConsumerPackageGrossContent { get; init; }
        /// <summary>
        /// &lt;p&gt;The consumer package content, as claimed on the label.  e.g. Evian Water 750ml - net content &#x3D; &#39;750 MLT&#39; 20 count pack of diapers, net content &#x3D; &#39;20 ea.&#39;&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The consumer package content, as claimed on the label.  e.g. Evian Water 750ml - net content &#x3D; &#39;750 MLT&#39; 20 count pack of diapers, net content &#x3D; &#39;20 ea.&#39;&lt;br /&gt;&lt;/p&gt;</value>
        public double? baseUOMConsumerPackageNetContent { get; init; }
        /// <summary>
        /// &lt;p&gt;Net/gross contents uom&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Net/gross contents uom&lt;br /&gt;&lt;/p&gt;</value>
        public string baseUOMConsumerPackageContentsUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Quantity measured in ConsumerPackageBasePriceUOMCode units for which the base price is to be determined&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * base price UOM &#x3D; g&lt;br /&gt;    * base price content &#x3D; 100&lt;br /&gt;    * base price &#x3D; 2,99&lt;br /&gt;    * &#x3D;&#x3D;&amp;gt; base price &#x3D; 2,99 per 100 g&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;Quantity measured in ConsumerPackageBasePriceUOMCode units for which the base price is to be determined&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * base price UOM &#x3D; g&lt;br /&gt;    * base price content &#x3D; 100&lt;br /&gt;    * base price &#x3D; 2,99&lt;br /&gt;    * &#x3D;&#x3D;&amp;gt; base price &#x3D; 2,99 per 100 g&lt;br /&gt;&lt;/pre&gt;</value>
        public double? baseUOMConsumerPackageBasePriceContent { get; init; }
        /// <summary>
        /// &lt;p&gt;Base price contents unit of measure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Base price contents unit of measure&lt;br /&gt;&lt;/p&gt;</value>
        public string baseUOMConsumerPackageBasePriceContentsUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the distributing warehouse (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the distributing warehouse (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;</value>
        public string distributingWarehouseID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the distribution method (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the distribution method (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;</value>
        public string distributionMethodID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the assortment (used e.g. in the purchase order process)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the assortment (used e.g. in the purchase order process)&lt;br /&gt;&lt;/p&gt;</value>
        public string assortmentID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the 3rd party assortment (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the 3rd party assortment (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;</value>
        public string thirdPartyAssortmentID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the transport association (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the transport association (used in the purchase order process)&lt;br /&gt;&lt;/p&gt;</value>
        public string transportAssociationID { get; init; }
        /// <summary>
        /// &lt;p&gt;If the item is a concession item, this is the reference to its supplier&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If the item is a concession item, this is the reference to its supplier&lt;br /&gt;&lt;/p&gt;</value>
        public string concessionItemSupplierID { get; init; }
        /// <summary>
        /// &lt;p&gt;The default selling unit of measure of the item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The default selling unit of measure of the item&lt;br /&gt;&lt;/p&gt;</value>
        public string defaultSellingUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Numerator for the conversion into base unit of measure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Numerator for the conversion into base unit of measure&lt;br /&gt;&lt;/p&gt;</value>
        public int? conversionNumerator { get; init; }
        /// <summary>
        /// &lt;p&gt;Denominator for the conversion into base unit of measure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Denominator for the conversion into base unit of measure&lt;br /&gt;&lt;/p&gt;</value>
        public int? conversionDenominator { get; init; }
        /// <summary>
        /// &lt;p&gt;The weight of the consumer package, including packaging&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The weight of the consumer package, including packaging&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageGrossWeight { get; init; }
        /// <summary>
        /// &lt;p&gt;The weight of the consumer package, excluding packaging&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The weight of the consumer package, excluding packaging&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageNetWeight { get; init; }
        /// <summary>
        /// &lt;p&gt;Weight unit of measure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Weight unit of measure&lt;br /&gt;&lt;/p&gt;</value>
        public string consumerPackageWeightUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The consumer package volume&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The consumer package volume&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageVolume { get; init; }
        /// <summary>
        /// &lt;p&gt;Volume unit of measure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Volume unit of measure&lt;br /&gt;&lt;/p&gt;</value>
        public string consumerPackageVolumeUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The dimension from front to back of the  consumer package&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The dimension from front to back of the  consumer package&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageDepth { get; init; }
        /// <summary>
        /// &lt;p&gt;The dimension from left to right of the consumer package&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The dimension from left to right of the consumer package&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageWidth { get; init; }
        /// <summary>
        /// &lt;p&gt;The dimension from top to bottom of the consumer package&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The dimension from top to bottom of the consumer package&lt;br /&gt;&lt;/p&gt;</value>
        public double? consumerPackageHeight { get; init; }
        /// <summary>
        /// &lt;p&gt;The code used to specify the units in which a value is being expressed, or manner in which a measurement has been taken.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The code used to specify the units in which a value is being expressed, or manner in which a measurement has been taken.&lt;br /&gt;&lt;/p&gt;</value>
        public string consumerPackageSizeUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Typecode of the outer package of the item, is used for label printing&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Typecode of the outer package of the item, is used for label printing&lt;br /&gt;&lt;/p&gt;</value>
        public string outerPackageTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Typecode of the outer package of the item, is used for label printing&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Typecode of the outer package of the item, is used for label printing&lt;br /&gt;&lt;/p&gt;</value>
        public string headOfficeCarryRequirementTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Handling typecode&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Handling typecode&lt;br /&gt;&lt;/p&gt;</value>
        public string handlingTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Date when the status becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Date when the status becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string statusEffectiveDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Maximum stock quantity&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Maximum stock quantity&lt;br /&gt;&lt;/p&gt;</value>
        public double? maximumStockQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;Minimum stock quantity&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Minimum stock quantity&lt;br /&gt;&lt;/p&gt;</value>
        public double? minimumStockQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;Date when the listing becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Date when the listing becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string listingEffectiveDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Last date when the item is available for ordering&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Last date when the item is available for ordering&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string listingExpirationDate { get; init; }
        /// <summary>
        /// &lt;p&gt;List of all Customer Specific Prices for this item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of all Customer Specific Prices for this item.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdPriceContractDtoDomPriceContractReadDO> PriceContractReadList { get; init; }
        /// <summary>
        /// &lt;p&gt;The Customer Specific Price for given timestamp (if specified, null otherwise).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The Customer Specific Price for given timestamp (if specified, null otherwise).&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdPriceContractDtoDomPriceContractReadDO selectedPriceContractRead { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM01 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string uomITEMXXCUSTOM30 { get; init; }
        /// <summary>
        /// &lt;p&gt;HSN (Harmonized System of Nomenclature) is an international classification system of commodities. HSN code ensures that commodities of similar nature are classified properly.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;HSN (Harmonized System of Nomenclature) is an international classification system of commodities. HSN code ensures that commodities of similar nature are classified properly.&lt;br /&gt;&lt;/p&gt;</value>
        public string hsncode { get; init; }
        /// <summary>
        /// &lt;p&gt;Denotes if RFID method is called and stock is updated.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true: The RFID method is called.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false: The RFID method is not called.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Denotes if RFID method is called and stock is updated.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true: The RFID method is called.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false: The RFID method is not called.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? rfidflag { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM01 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemXXCUSTOM30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM01 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string bulkITEMXXCUSTOM30 { get; init; }
	}
}
