namespace POSGkSwaggerModel
{
    /// <summary>
    /// PriceContractReadDO &lt;p&gt;The view object which consolidates data from Price Contract tables.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareGkrApiServerMdPriceContractDtoDomPriceContractReadDO	{
        /// <summary>
        /// &lt;p&gt;The identifier of a contract which was created for a customer or customer group&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The identifier of a contract which was created for a customer or customer group&lt;br /&gt;&lt;/p&gt;</value>
        public string priceContractID { get; init; }
        /// <summary>
        /// &lt;p&gt;Reference to the Item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reference to the Item.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The POS Item ID.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The POS Item ID.&lt;br /&gt;&lt;/p&gt;</value>
        public string posItemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The UOM of the Item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The UOM of the Item.&lt;br /&gt;&lt;/p&gt;</value>
        public string unitOfMeasureCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Effective (start) Time Stamp of that price.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Effective (start) Time Stamp of that price.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string effectiveDateTime { get; init; }
        /// <summary>
        /// &lt;p&gt;Expiration (end) Time Stamp of that price.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Expiration (end) Time Stamp of that price.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string expirationDateTime { get; init; }
        /// <summary>
        /// &lt;p&gt;The agreed sales unit price for the item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The agreed sales unit price for the item.&lt;br /&gt;&lt;/p&gt;</value>
        public double? saleUnitRetailPriceAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique system assigned identifier for the Customer.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique system assigned identifier for the Customer.&lt;br /&gt;&lt;/p&gt;</value>
        public string customerID { get; init; }
        /// <summary>
        /// &lt;p&gt;Customer group ID.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customer group ID.&lt;br /&gt;&lt;/p&gt;</value>
        public string customerGroupID { get; init; }
	}
}
