namespace POSGkSwaggerModel
{
    /// <summary>
    /// TenderDO &lt;p&gt;Tender includes all the forms of payment that are accepted by the retail store in settling sales and other transactions.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareGkrApiServerMdTenderDtoDomTenderDO	{
        /// <summary>
        /// &lt;p&gt;Defines type of tender pickup:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; NOT_ALLOWED(01) - Not allowed&lt;/li&gt;&lt;br /&gt; &lt;li&gt; ALLOWED(02) - Allowed&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines type of tender pickup:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; NOT_ALLOWED(01) - Not allowed&lt;/li&gt;&lt;br /&gt; &lt;li&gt; ALLOWED(02) - Allowed&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public pickupTypeCodeEnum? pickupTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A typecode to define how a tender is picked up from safe / delivered to bank:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; NO_DELIVERY(00) - no delivery&lt;/li&gt;&lt;br /&gt; &lt;li&gt; MANUAL_DELIVERY(01) - manual delivery&lt;/li&gt;&lt;br /&gt; &lt;li&gt; AUTOMATIC_DELIVERY(02) - automatic delivery&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;A typecode to define how a tender is picked up from safe / delivered to bank:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; NO_DELIVERY(00) - no delivery&lt;/li&gt;&lt;br /&gt; &lt;li&gt; MANUAL_DELIVERY(01) - manual delivery&lt;/li&gt;&lt;br /&gt; &lt;li&gt; AUTOMATIC_DELIVERY(02) - automatic delivery&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public deliveryTypeCodeEnum? deliveryTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether payment amount should be entered.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; REQUIRED(01) - required&lt;/li&gt;&lt;br /&gt; &lt;li&gt; OPTIONAL(02) - optional&lt;/li&gt;&lt;br /&gt; &lt;li&gt; PROHIBITED(03) - prohibited&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CONFIRM(04) - confirm&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether payment amount should be entered.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; REQUIRED(01) - required&lt;/li&gt;&lt;br /&gt; &lt;li&gt; OPTIONAL(02) - optional&lt;/li&gt;&lt;br /&gt; &lt;li&gt; PROHIBITED(03) - prohibited&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CONFIRM(04) - confirm&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public inputAmountConstraintEnum? inputAmountConstraint { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines what amount is allowed.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; EXACTLY(01) - EXACTLY&lt;/li&gt;&lt;br /&gt; &lt;li&gt; EXACTLY_AND_LESS(02) - EXACTLY_AND_LESS&lt;/li&gt;&lt;br /&gt; &lt;li&gt; EXACTLY_AND_MORE(03) - EXACTLY_AND_MORE&lt;/li&gt;&lt;br /&gt; &lt;li&gt; ALL(04) - ALL&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines what amount is allowed.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; EXACTLY(01) - EXACTLY&lt;/li&gt;&lt;br /&gt; &lt;li&gt; EXACTLY_AND_LESS(02) - EXACTLY_AND_LESS&lt;/li&gt;&lt;br /&gt; &lt;li&gt; EXACTLY_AND_MORE(03) - EXACTLY_AND_MORE&lt;/li&gt;&lt;br /&gt; &lt;li&gt; ALL(04) - ALL&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public allowedAmountTypeCodeEnum? allowedAmountTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the tender group used by POS payment functions:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; CASH,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; TERMINAL,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; GIFT_CERT,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; COUPON,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CHEQUE,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CREDIT,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; PROMOTION,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; POINTS,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CASHENGINE&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the tender group used by POS payment functions:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; CASH,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; TERMINAL,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; GIFT_CERT,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; COUPON,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CHEQUE,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CREDIT,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; PROMOTION,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; POINTS,&lt;/li&gt;&lt;br /&gt; &lt;li&gt; CASHENGINE&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public tenderGroupCodeEnum? tenderGroupCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the tender can be used only for sales, only for returns, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; SALES_AND_RETURNS(00) - for sales and returns&lt;/li&gt;&lt;br /&gt; &lt;li&gt; SALES(01) - only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt; RETURNS(02) - only for returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the tender can be used only for sales, only for returns, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; SALES_AND_RETURNS(00) - for sales and returns&lt;/li&gt;&lt;br /&gt; &lt;li&gt; SALES(01) - only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt; RETURNS(02) - only for returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public saleReturnTypeCodeEnum? saleReturnTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether for this tender will be printed sales receipt:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; AUTOMATIC_PRINTOUT(00) - automatic printout of sales receipt&lt;/li&gt;&lt;br /&gt; &lt;li&gt; OPTIONAL_PRINTOUT(01) - optional printout (decision by user)&lt;/li&gt;&lt;br /&gt; &lt;li&gt; NO_AUTOMATIC_PRINTOUT(02) - no automatic printout&lt;/li&gt;&lt;br /&gt; &lt;li&gt; RECEIPT_AS_EMAIL(03) - receipt as email&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether for this tender will be printed sales receipt:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; AUTOMATIC_PRINTOUT(00) - automatic printout of sales receipt&lt;/li&gt;&lt;br /&gt; &lt;li&gt; OPTIONAL_PRINTOUT(01) - optional printout (decision by user)&lt;/li&gt;&lt;br /&gt; &lt;li&gt; NO_AUTOMATIC_PRINTOUT(02) - no automatic printout&lt;/li&gt;&lt;br /&gt; &lt;li&gt; RECEIPT_AS_EMAIL(03) - receipt as email&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public receiptPrintoutTypeCodeEnum? receiptPrintoutTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A typecode to signify that only a specific group of items can be purchased using this tender.&lt;br /&gt; Possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; WIC - tender is allowed only for items with WICFlag&lt;/li&gt;&lt;br /&gt; &lt;li&gt; FOST- tender is allowed only for items with AllowFoodStampFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;A typecode to signify that only a specific group of items can be purchased using this tender.&lt;br /&gt; Possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt; WIC - tender is allowed only for items with WICFlag&lt;/li&gt;&lt;br /&gt; &lt;li&gt; FOST- tender is allowed only for items with AllowFoodStampFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public itemRestrictApplyTypeCodeEnum? itemRestrictApplyTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Type of origin.&lt;br /&gt; OriginCode:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt; PARENT_COPY &#x3D; &#39;00&#39;&lt;br /&gt; IMPORT &#x3D; &#39;01&#39;&lt;br /&gt; MANUAL &#x3D; &#39;02&#39;&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type of origin.&lt;br /&gt; OriginCode:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt; PARENT_COPY &#x3D; &#39;00&#39;&lt;br /&gt; IMPORT &#x3D; &#39;01&#39;&lt;br /&gt; MANUAL &#x3D; &#39;02&#39;&lt;br /&gt;&lt;/pre&gt;</value>
        public originEnum? origin { get; init; }
        /// <summary>
        /// &lt;p&gt;Getter for inner key class.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Getter for inner key class.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdTenderDtoDomTenderDOkey key { get; init; }
        /// <summary>
        /// &lt;p&gt;A code to denote a group of tenders with common characteristics, e.g. payment cards, certificates, etc.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code to denote a group of tenders with common characteristics, e.g. payment cards, certificates, etc.&lt;br /&gt;&lt;/p&gt;</value>
        public string tenderClassCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Description of the tender type.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Description of the tender type.&lt;br /&gt;&lt;/p&gt;</value>
        public string description { get; init; }
        /// <summary>
        /// &lt;p&gt;The minimum value that can be accepted for an individual tender. For example, certain retailers will not accept card payments below $5.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The minimum value that can be accepted for an individual tender. For example, certain retailers will not accept card payments below $5.&lt;br /&gt;&lt;/p&gt;</value>
        public double? minimumAcceptAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;The maximum amount that can be accepted for a specific tender type.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The maximum amount that can be accepted for a specific tender type.&lt;br /&gt;&lt;/p&gt;</value>
        public double? maximumAcceptAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to signify that specific groups of items cannot be purchased using certain tender types. For example, food stamps cannot be used to purchase alcohol or tobacco items.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to signify that specific groups of items cannot be purchased using certain tender types. For example, food stamps cannot be used to purchase alcohol or tobacco items.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? itemRestrictionsApplyFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag that signifies that the cash drawer opens if a certain specific tender type is offered by the customer. For example, cash.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag that signifies that the cash drawer opens if a certain specific tender type is offered by the customer. For example, cash.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? openCashDrawerRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The maximum change that can be offered to a customer for a specific tender type.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The maximum change that can be offered to a customer for a specific tender type.&lt;br /&gt;&lt;/p&gt;</value>
        public double? changeThresholdAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the tender should be shown in accounting functions for tills.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the tender should be shown in accounting functions for tills.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? tillCountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether denomination is applicable for the tender.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether denomination is applicable for the tender.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? denominationFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether change is possible.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether change is possible.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? changeAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines if the tender count is registered in accounting functions.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines if the tender count is registered in accounting functions.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? unitCountRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines if the tender amount is registered in accounting functions.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines if the tender amount is registered in accounting functions.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? amountCountRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether a sales transaction which contains this tender can be voided later.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether a sales transaction which contains this tender can be voided later.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? voidingAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this tender is allowed for deposit.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this tender is allowed for deposit.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? depositAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this tender can be used for payment and accounting.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this tender can be used for payment and accounting.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? blockingFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the tender should be shown in safe accounting functions.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the tender should be shown in safe accounting functions.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? controlledBySafeFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;This flag determines whether the current value of the tender in the till is checked.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This flag determines whether the current value of the tender in the till is checked.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? checkAvailableAmountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;If this flag is set to true, a warning is shown on POS in the case that the actual amount of the till for that tender is equal or larger than the PickupWarningLimit&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If this flag is set to true, a warning is shown on POS in the case that the actual amount of the till for that tender is equal or larger than the PickupWarningLimit&lt;br /&gt;&lt;/p&gt;</value>
        public bool? pickupWarningFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the limit for a tender pickup from the till, see also PickupWarningFlag&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the limit for a tender pickup from the till, see also PickupWarningFlag&lt;br /&gt;&lt;/p&gt;</value>
        public double? pickupWarningLimit { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether this tender can be voided during the tender registration process (i.e. while the transaction is not finished yet)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether this tender can be voided during the tender registration process (i.e. while the transaction is not finished yet)&lt;br /&gt;&lt;/p&gt;</value>
        public bool? immediateVoidingAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional tender description which is used on POS side.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional tender description which is used on POS side.&lt;br /&gt;&lt;/p&gt;</value>
        public string receiptPrinterName { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines whether this tender can be used only exclusively, i.e. no other tenders can be combined with it in one transaction.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines whether this tender can be used only exclusively, i.e. no other tenders can be combined with it in one transaction.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? exclusiveFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Sort sequence for tenders in reports and backoffice functions.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sort sequence for tenders in reports and backoffice functions.&lt;br /&gt;&lt;/p&gt;</value>
        public int? sortSequence { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this tender will be counted for safe.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this tender will be counted for safe.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? safeCountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether negative values can be input; is used in the context of foreign turnover registration.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether negative values can be input; is used in the context of foreign turnover registration.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? negativeValueAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the tender amount has to be rounded according to the rounding rules of the main currency&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the tender amount has to be rounded according to the rounding rules of the main currency&lt;br /&gt;&lt;/p&gt;</value>
        public bool? roundingRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Reference to the tender handling rule (tender fields additional to ARTS)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reference to the tender handling rule (tender fields additional to ARTS)&lt;br /&gt;&lt;/p&gt;</value>
        public string tenderHandlingRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;List of tender restriction rules.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of tender restriction rules.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdTenderDtoDomTenderRestrictionRule> TenderRestrictionRuleList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations for the tender.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations for the tender.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerCommonTranslationsDtoDomTranslationDO> TranslationList { get; init; }
        /// <summary>
        /// &lt;p&gt;Internal identification of the import package (e.g. IDoc file). The identification is used for monitoring purposes.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Internal identification of the import package (e.g. IDoc file). The identification is used for monitoring purposes.&lt;br /&gt;&lt;/p&gt;</value>
        public string packageID { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;The identifier of the currency used for the tender.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The identifier of the currency used for the tender.&lt;br /&gt;&lt;/p&gt;</value>
        public string isocurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
	}
}
