namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionLineItemAssociation.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoRetailTransactionLineItemAssociationKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier (UUID) for the Transaction.
        /// </summary>
        /// <value>A universally unique identifier (UUID) for the Transaction.</value>
        public string transactionID { get; init; }
        /// <summary>
        /// The sequence number of line item
        /// </summary>
        /// <value>The sequence number of line item</value>
        public int? lineItemSequenceNumber { get; init; }
        /// <summary>
        /// The transaction id of the linked transaction.
        /// </summary>
        /// <value>The transaction id of the linked transaction.</value>
        public string toTransactionID { get; init; }
        /// <summary>
        /// The sequence number of the linked line item.
        /// </summary>
        /// <value>The sequence number of the linked line item.</value>
        public int? toLineItemSequenceNumber { get; init; }
        /// <summary>
        /// A retailer assigned code denoting the relationship between the two items.
        /// </summary>
        /// <value>A retailer assigned code denoting the relationship between the two items.</value>
        public string lineItemAssociationTypeCode { get; init; }
        /// <summary>
        /// A unique system assigned identifier for the the business unit group of the linked transaction.
        /// </summary>
        /// <value>A unique system assigned identifier for the the business unit group of the linked transaction.</value>
        public string toBusinessUnitGroupID { get; init; }
	}
}
